/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef opengl_COpenGLStandardObject_H
#define opengl_COpenGLStandardObject_H

#include <mrpt/opengl/CRenderizable.h>
#include <mrpt/poses/CPoint3D.h>

#include <mrpt/utils/stl_extensions.h>

namespace mrpt	{
	namespace opengl	{
		using namespace mrpt::utils;
		using namespace mrpt::poses;
		class MRPTDLLIMPEXP COpenGLStandardObject;
		DEFINE_SERIALIZABLE_PRE_CUSTOM_BASE(COpenGLStandardObject,CRenderizable)
		/** Any OpenGLObject without special geometric properties
		  */
		class MRPTDLLIMPEXP COpenGLStandardObject:public CRenderizable	{
			DEFINE_SERIALIZABLE(COpenGLStandardObject)
		protected:
			unsigned int type;
			vector_serializable<CPoint3D> vertices;
			uint32_t chunkSize;
		public:
			/** Render
			  */
			virtual void render() const;
			/** Ray Trace
			  */
			virtual bool traceRay(const mrpt::poses::CPose3D &o,float &dist) const;
			static COpenGLStandardObjectPtr Create(unsigned int t,const std::vector<CPoint3D> &v,uint32_t cs=0)	{
				if (cs!=0&&v.size()%cs!=0) throw std::logic_error("Vertices vector does not match chunk size");
				return COpenGLStandardObjectPtr(new COpenGLStandardObject(t,v,cs));
			}
		private:
			/** Constructor
			  */
			COpenGLStandardObject(unsigned int t,const std::vector<CPoint3D> &v,uint32_t cs):type(t),vertices(v),chunkSize(cs)	{}
			COpenGLStandardObject():type(0),vertices(std::vector<CPoint3D>(0)),chunkSize(0)	{}
			/** Private, virtual destructor: only can be deleted from smart pointers */
			virtual ~COpenGLStandardObject()	{}
		};
	} // end namespace
} // End of namespace
#endif
