/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef CFORMEDIT_H
#define CFORMEDIT_H

#include <wx/listbox.h>

//(*Headers(CFormEdit)
#include <wx/checklst.h>
#include <wx/spinctrl.h>
#include <wx/checkbox.h>
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/radiobut.h>
#include <wx/slider.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
//*)


#include <wx/combobox.h>


#include <mrpt/slam/CActionCollection.h>
#include <mrpt/slam/CSensoryFrame.h>


class CFormEdit: public wxDialog
{
public:

    CFormEdit(wxWindow* parent,wxWindowID id = -1);
    virtual ~CFormEdit();

	/** Used in executeOperationOnRawlogFiles
	  */
	typedef void (*TRawlogFilter)( mrpt::slam::CActionCollection *acts, mrpt::slam::CSensoryFrame *SF, int &changesCount  );
    /** This is the common function for all operations over a rawlog file ("filter" a rawlog file into a new one) or over the loaded rawlog (depending on the user selection in the GUI).
      */
    void executeOperationOnRawlog( TRawlogFilter operation, const char *endMsg);


    //(*Identifiers(CFormEdit)
    static const long ID_RADIOBUTTON1;
    static const long ID_RADIOBUTTON2;
    static const long ID_STATICTEXT22;
    static const long ID_TEXTCTRL11;
    static const long ID_BUTTON9;
    static const long ID_STATICTEXT23;
    static const long ID_TEXTCTRL12;
    static const long ID_BUTTON11;
    static const long ID_STATICTEXT1;
    static const long ID_SLIDER1;
    static const long ID_SPINCTRL1;
    static const long ID_STATICTEXT3;
    static const long ID_SLIDER2;
    static const long ID_SPINCTRL2;
    static const long ID_BUTTON1;
    static const long ID_BUTTON2;
    static const long ID_CHECKBOX1;
    static const long ID_CHECKBOX2;
    static const long ID_CHECKBOX3;
    static const long ID_CHECKBOX4;
    static const long ID_CHECKBOX5;
    static const long ID_BUTTON4;
    static const long ID_CHECKBOX6;
    static const long ID_CHECKBOX7;
    static const long ID_CHECKBOX8;
    static const long ID_CHECKBOX9;
    static const long ID_CHECKBOX10;
    static const long ID_BUTTON5;
    static const long ID_CHECKLISTBOX2;
    static const long ID_BUTTON7;
    static const long ID_BUTTON8;
    static const long ID_CHECKLISTBOX1;
    static const long ID_BUTTON10;
    static const long ID_BUTTON12;
    static const long ID_BUTTON13;
    static const long ID_STATICTEXT2;
    static const long ID_TEXTCTRL2;
    static const long ID_BUTTON3;
    static const long ID_BUTTON6;
    //*)

public:

    //(*Handlers(CFormEdit)
    void OnbtnCloseClick(wxCommandEvent& event);
    void OnslFirstCmdScrollChanged(wxScrollEvent& event);
    void OnslToCmdScrollChanged(wxScrollEvent& event);
    void OnbtnKeepClick(wxCommandEvent& event);
    void OnbtnDeleteClick(wxCommandEvent& event);
    void OnbtnDelObsIndxClick(wxCommandEvent& event);
    void OnbtnRemoveObsClassClick(wxCommandEvent& event);
    void OnbtnRemActsIndxClick(wxCommandEvent& event);
    void OnbtnImgSwapClick(wxCommandEvent& event);
    void OnInit(wxInitDialogEvent& event);
    void OnrbLoadedSelect(wxCommandEvent& event);
    void OnrbFileSelect(wxCommandEvent& event);
    void OnbtnRemoveAllButByClassClick1(wxCommandEvent& event);
    void OnbtnPickInputClick(wxCommandEvent& event);
    void OnbtnPickOutClick(wxCommandEvent& event);
    void OnRemoveByLabel(wxCommandEvent& event);
    void OnRemoveButLabel(wxCommandEvent& event);
    void OnslFromCmdScroll(wxScrollEvent& event);
    void OnslFromCmdScroll1(wxScrollEvent& event);
    void OnbtnLeaveHorizScansClick(wxCommandEvent& event);
    //*)

    //(*Declarations(CFormEdit)
    wxCheckBox* cbA3;
    wxStaticBoxSizer* StaticBoxSizer2;
    wxCheckBox* cbA1;
    wxButton* btnRemoveAllButByClass;
    wxCheckListBox* cbObsLabel;
    wxButton* btnDelete;
    wxStaticText* StaticText22;
    wxFlexGridSizer* FlexGridSizer8;
    wxFlexGridSizer* FlexGridSizer1;
    wxFlexGridSizer* FlexGridSizer2;
    wxTextCtrl* edMaxPitch;
    wxCheckBox* cbO3;
    wxButton* btnKeep;
    wxStaticBoxSizer* StaticBoxSizer7;
    wxButton* btnClose;
    wxSlider* slTo;
    wxButton* btnLeaveHorizScans;
    wxButton* btnPickInput;
    wxButton* btnDelObsIndx;
    wxStaticBoxSizer* StaticBoxSizer5;
    wxCheckBox* cbO4;
    wxButton* btnRemByLabel;
    wxFlexGridSizer* FlexGridSizer11;
    wxTextCtrl* txtOutputFile;
    wxCheckBox* cbO1;
    wxFlexGridSizer* FlexGridSizer7;
    wxButton* btnRemActsIndx;
    wxBoxSizer* BoxSizer2;
    wxFlexGridSizer* FlexGridSizer4;
    wxStaticText* StaticText1;
    wxButton* btnPickOut;
    wxRadioButton* rbFile;
    wxFlexGridSizer* FlexGridSizer9;
    wxStaticBoxSizer* StaticBoxSizer3;
    wxFlexGridSizer* FlexGridSizer6;
    wxCheckBox* cbA0;
    wxStaticText* StaticText3;
    wxSlider* slFrom;
    wxStaticText* StaticText23;
    wxCheckBox* cbA2;
    wxSpinCtrl* spinLast;
    wxCheckBox* cbA4;
    wxFlexGridSizer* FlexGridSizer3;
    wxBoxSizer* BoxSizer4;
    wxStaticBoxSizer* StaticBoxSizer4;
    wxStaticBoxSizer* StaticBoxSizer6;
    wxButton* btnRemByLabelNon;
    wxRadioButton* rbLoaded;
    wxBoxSizer* BoxSizer1;
    wxStaticText* StaticText2;
    wxButton* btnImgSwap;
    wxSpinCtrl* spinFirst;
    wxCheckBox* cbO0;
    wxCheckBox* cbO2;
    wxTextCtrl* txtInputFile;
    wxButton* btnRemoveObsClass;
    wxCheckListBox* cbObsClass;
    wxBoxSizer* BoxSizer5;
    wxStaticBoxSizer* StaticBoxSizer1;
    //*)

private:

    DECLARE_EVENT_TABLE()
};

#endif
