/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#include <mrpt/precomp_core.h>  // Only for precomp. headers, include all libmrpt-core headers.

#include <mrpt/utils.h>
#include <mrpt/math_mrpt.h>
#include <mrpt/slam.h>
#include <mrpt/poses.h>

using namespace mrpt::utils;
using namespace mrpt::math;
using namespace mrpt::slam;
using namespace mrpt::poses;
using namespace mrpt::opengl;

/*---------------------------------------------------------------
					registerAllClasses
  ---------------------------------------------------------------*/
void mrpt::registerAllClasses()
{
	// Abstract classes are not registered since they can not be
	//   instanciated, nor loaded from streams.
	registerClass( CLASS_ID( CMatrix ) );
	registerClass( CLASS_ID( CMatrixD ) );
	registerClass( CLASS_ID( CPolygon ) );
	registerClass( CLASS_ID( COpenGLScene ) );
	registerClass( CLASS_ID( CMRPTImage ) );
	registerClass( CLASS_ID( CMRPTImageFloat) );
	registerClass( CLASS_ID( CSimpleDatabase ) );
	registerClass( CLASS_ID( CSimpleDatabaseTable ) );
	registerClass( CLASS_ID( CPropertiesValuesList ) );
	registerClass( CLASS_ID( CMHPropertiesValuesList ) );
	registerClass( CLASS_ID( CTypeSelector ) );
	registerClass( CLASS_ID( CMemoryChunk ) );

	registerClass( CLASS_ID( CPoint2D ) );
	registerClass( CLASS_ID( CPoint3D ) );
	registerClass( CLASS_ID( CPose2D ) );
	registerClass( CLASS_ID( CPose3D ) );
	registerClass( CLASS_ID( CPoses2DSequence ) );
	registerClass( CLASS_ID( CPoses3DSequence ) );

	registerClass( CLASS_ID( CSimplePointsMap ) );
	registerClass( CLASS_ID( CColouredPointsMap ) );
	registerClass( CLASS_ID( COccupancyGridMap2D ) );
	registerClass( CLASS_ID( CGasConcentrationGridMap2D ) );
	registerClass( CLASS_ID( CLandmarksMap ) );
	registerClass( CLASS_ID( CLandmark ) );

	registerClass( CLASS_ID( CBeacon ) );
	registerClass( CLASS_ID( CBeaconMap ) );

// -------------------------------------------------------------------------------
//   The CHybridMetricMap-HACK:		*** "Temporary" hack!! :-( ***
//  The name of this class was previously "CHybridMetricMap", but eventually
//  suffered MAJOR changes and the name was changed to the current one. This implies
//  some 'hacks' to allow portability in the old serializations. This hack will
//  be eventually removed when all old data become ported to the new format!
//                                                          JLBC, 11/DEC/2006
// -------------------------------------------------------------------------------
	registerClass( CLASS_ID( CMultiMetricMap ) );
	registerClass( &CMultiMetricMap::classCHybridMetricMap );

	registerClass( CLASS_ID( CSensoryFrame ) );
	registerClass( CLASS_ID( CSensFrameProbSequence ) );
	registerClass( CLASS_ID( CObservationRange ) );
	registerClass( CLASS_ID( CObservation2DRangeScan ) );
	registerClass( CLASS_ID( CObservationImage ) );
	registerClass( CLASS_ID( CObservationVisualLandmarks ) );
	registerClass( CLASS_ID( CObservationStereoImages ) );
	registerClass( CLASS_ID( CObservationGasSensors ) );
	registerClass( CLASS_ID( CObservationGPS ) );
	registerClass( CLASS_ID( CObservationIMU ) );
	registerClass( CLASS_ID( CObservationBearingRange ) );
	registerClass( CLASS_ID( CObservationOdometry ) );

	registerClass( CLASS_ID( CRawlog ) );

	registerClass( CLASS_ID( CActionCollection ) );
	registerClass( CLASS_ID( CActionRobotMovement2D ) );
	registerClass( CLASS_ID( CActionRobotMovement3D ) );

	registerClass( CLASS_ID( CPosePDFGaussian ) );
	registerClass( CLASS_ID( CPosePDFParticles ) );
	registerClass( CLASS_ID( CPosePDFGrid ) );
	registerClass( CLASS_ID( CPointPDFGaussian ) );
	registerClass( CLASS_ID( CPose3DPDFGaussian ) );
	registerClass( CLASS_ID( CPointPDFParticles ) );

	registerClass( CLASS_ID( CPose3DInterpolator ) );

	// Opengl classes:
	registerClass( CLASS_ID( C3DSScene ) );
	registerClass( CLASS_ID( CAxis ) );    
	registerClass( CLASS_ID( CDisk ) );
	registerClass( CLASS_ID( CGridPlaneXY ) );
	registerClass( CLASS_ID( CMesh ) );
	registerClass( CLASS_ID( COpenGLViewport ) );
	registerClass( CLASS_ID( CPointCloud ) );
	registerClass( CLASS_ID( CPointCloudColoured ) );
	registerClass( CLASS_ID( CSetOfLines ) );
	registerClass( CLASS_ID( CSetOfTriangles ) );
	registerClass( CLASS_ID( CSphere ) );
	registerClass( CLASS_ID( CTexturedPlane ) );
	registerClass( CLASS_ID( CArrow ) );    
	registerClass( CLASS_ID( CCamera ) );
	registerClass( CLASS_ID( CEllipsoid  ) ); 
	registerClass( CLASS_ID( CGridPlaneXZ ) ); 
	registerClass( CLASS_ID( COpenGLScene ) );
	registerClass( CLASS_ID( CPlanarLaserScan ) );
	registerClass( CLASS_ID( CSetOfObjects ) );
	registerClass( CLASS_ID( CSimpleLine ) );
	registerClass( CLASS_ID( CText ) );

}
