/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef mrpt_utils_types_H
#define mrpt_utils_types_H

#include <vector>
#include <string>

// Standard elemental types:
#include "pstdint.h"  // The "portable stdint header file"

#define __STDC_FORMAT_MACROS
#if HAVE_INTTYPES_H
#	include <inttypes.h>
#elif defined(_MSC_VER)
#	include	<mrpt/utils/msvc_inttypes.h>
#endif


/** A type for passing a vector of longs.
*/
typedef std::vector<int64_t> vector_long;

/** A type for passing a vector of ints.
*/
typedef std::vector<int32_t> vector_int;

/** A type for passing a vector of floats.
*/
typedef std::vector<float> vector_float;

/** A type for passing a vector of doubles.
*/
typedef std::vector<double> vector_double;

/** A type for passing a vector of 16-bits unsigned numbers.
*/
typedef std::vector<uint16_t> vector_word;

/** A type for passing a vector of 32-bits unsigned numbers.
*/
typedef std::vector<uint32_t> vector_uint;

/** A type for passing a vector of strings.
*/
typedef std::vector<std::string> vector_string;

/** A type for passing a vector of boolean values.
*/
typedef std::vector<bool> vector_bool;

/** A type for passing a vector of bytes.
*/
typedef std::vector<uint8_t> vector_byte;

/** A type for vectors of size_t's.
*/
typedef std::vector<size_t> vector_size_t;

#endif

