/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;

public class Coord
implements DataIO {
    public static final Comparator LINEID_ORDER = new LineIDOrder();
    public static final int BYTESIZE = 12;
    public double time;
    public int lineID;

    public Coord(double d, int n) {
        this.time = d;
        this.lineID = n;
    }

    public Coord(Coord coord) {
        this.time = coord.time;
        this.lineID = coord.lineID;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.time);
        dataOutput.writeInt(this.lineID);
    }

    public Coord(DataInput dataInput) throws IOException {
        this.readObject(dataInput);
    }

    @Override
    public void readObject(DataInput dataInput) throws IOException {
        this.time = dataInput.readDouble();
        this.lineID = dataInput.readInt();
    }

    public int getByteSize() {
        return 12;
    }

    public String toString() {
        return "(" + (float)this.time + ", " + this.lineID + ")";
    }

    private static class LineIDOrder
    implements Comparator {
        private LineIDOrder() {
        }

        public int compare(Object object, Object object2) {
            Coord coord = (Coord)object;
            Coord coord2 = (Coord)object2;
            return coord.lineID - coord2.lineID;
        }
    }
}

