/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import viewer.common.Routines;
import viewer.zoomable.Debug;
import viewer.zoomable.ViewportTime;

public class ViewportTimePanel
extends JPanel {
    private static final long serialVersionUID = 4600L;
    private ViewportTime viewport;
    private static Border border;
    private String borderTitle;
    private int borderTitleJustification;
    private int borderTitlePosition;
    private Font borderTitleFont;
    private Color borderTitleColor;

    public ViewportTimePanel(ViewportTime viewportTime) {
        super(new BorderLayout());
        this.viewport = viewportTime;
        super.add((Component)this.viewport, "Center");
        super.setBackground(Color.white);
        if (border == null) {
            border = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());
        }
        this.borderTitle = null;
        this.borderTitleJustification = 0;
        this.borderTitlePosition = 0;
        this.borderTitleFont = null;
        this.borderTitleColor = null;
    }

    public static void setDefaultBorder(Border border) {
        ViewportTimePanel.border = border;
    }

    public void setBorderTitle(String string, int n, int n2, Font font, Color color) {
        if (string != null) {
            this.borderTitle = string;
            this.borderTitleJustification = n;
            this.borderTitlePosition = n2;
            this.borderTitleFont = font;
            this.borderTitleColor = color;
        }
        this.setBorder();
    }

    private void setBorder() {
        Border border = this.borderTitle != null ? BorderFactory.createTitledBorder(ViewportTimePanel.border, this.borderTitle, this.borderTitleJustification, this.borderTitlePosition, this.borderTitleFont, this.borderTitleColor) : ViewportTimePanel.border;
        super.setBorder(border);
        if (this.viewport != null) {
            Insets insets = this.getInsets();
            if (Debug.isActive()) {
                Debug.println("ViewportTimePanel(): this.insets = " + insets);
            }
            Dimension dimension = Routines.correctSize(this.viewport.getMinimumSize(), insets);
            super.setMinimumSize(dimension);
            Dimension dimension2 = Routines.correctSize(this.viewport.getMaximumSize(), insets);
            super.setMaximumSize(dimension2);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (Debug.isActive()) {
            Debug.println("ViewportTimePanel(): min_size = " + dimension);
        }
        return dimension;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (Debug.isActive()) {
            Debug.println("ViewportTimePanel(): max_size = " + dimension);
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (Debug.isActive()) {
            Debug.println("ViewportTimePanel(): pref_size = " + dimension);
        }
        return dimension;
    }
}

