/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2TOdrawable;

import base.drawable.Coord;
import base.drawable.Primitive;
import base.drawable.YCoordMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import logformat.clog2.RecComm;
import logformat.clog2TOdrawable.CommProcThdID;

public class CommProcThdIDMap
extends TreeMap {
    private static final long serialVersionUID = 300L;
    private int max_thread_count;

    public CommProcThdIDMap(int max_thread_count) {
        super(Coord.LINEID_ORDER);
        this.max_thread_count = max_thread_count;
    }

    public void addComm(RecComm comm) {
        for (int thd = 0; thd < this.max_thread_count; ++thd) {
            CommProcThdID cptID = new CommProcThdID(comm, thd);
            Coord key = new Coord(0.0, cptID.gthdLineID);
            if (super.containsKey(key)) continue;
            super.put(key, cptID);
        }
    }

    public void setCommProcThdIDUsed(Primitive prime) {
        CommProcThdID cptID = (CommProcThdID)super.get(prime.getStartVertex());
        if (cptID == null) {
            System.err.println("CommProcThdIDMap: missing CommProcThdID element with gthdLineID " + prime.getStartVertex().lineID + "!");
        }
        cptID.setUsed(true);
        if (prime.getCategory().getTopology().isArrow()) {
            cptID = (CommProcThdID)super.get(prime.getFinalVertex());
            if (cptID == null) {
                System.err.println("CommProcThdIDMap: missing CommProcThdID element with gthdLineID " + prime.getFinalVertex().lineID + "!");
            }
            cptID.setUsed(true);
        }
    }

    public void initialize() {
    }

    public void finish() {
        Iterator coord_cptID_itr = super.entrySet().iterator();
        while (coord_cptID_itr.hasNext()) {
            Map.Entry coord_cptID = coord_cptID_itr.next();
            CommProcThdID cptID = (CommProcThdID)coord_cptID.getValue();
            if (cptID.isUsed()) continue;
            coord_cptID_itr.remove();
        }
    }

    public List createYCoordMapList() {
        ArrayList<YCoordMap> ycoordmap_list = new ArrayList<YCoordMap>(2);
        int num_rows = super.size();
        if (this.max_thread_count > 1) {
            int num_cols4wthd = 3;
            int wthd_idx = 0;
            int[] wthd_elems = new int[num_rows * num_cols4wthd];
            int num_cols4gthd = 4;
            int gthd_idx = 0;
            int[] gthd_elems = new int[num_rows * num_cols4gthd];
            Iterator cptID_itr = super.values().iterator();
            while (cptID_itr.hasNext()) {
                CommProcThdID cptID = (CommProcThdID)cptID_itr.next();
                wthd_elems[wthd_idx++] = cptID.gthdLineID;
                wthd_elems[wthd_idx++] = cptID.wrank;
                wthd_elems[wthd_idx++] = cptID.thd;
                gthd_elems[gthd_idx++] = cptID.gthdLineID;
                gthd_elems[gthd_idx++] = cptID.icomm;
                gthd_elems[gthd_idx++] = cptID.rank;
                gthd_elems[gthd_idx++] = cptID.thd;
            }
            String[] col_titles = new String[]{"world_rank", "thread"};
            YCoordMap wthd_viewmap = new YCoordMap(num_rows, num_cols4wthd, "Process-Thread View", col_titles, wthd_elems, null);
            ycoordmap_list.add(wthd_viewmap);
            col_titles = new String[]{"commID", "comm_rank", "thread"};
            YCoordMap gthd_viewmap = new YCoordMap(num_rows, num_cols4gthd, "Communicator-Thread View", col_titles, gthd_elems, null);
            ycoordmap_list.add(gthd_viewmap);
        } else {
            int num_cols4world = 2;
            int world_idx = 0;
            int[] world_elems = new int[num_rows * num_cols4world];
            int num_cols4comm = 3;
            int comm_idx = 0;
            int[] comm_elems = new int[num_rows * num_cols4comm];
            Iterator cptID_itr = super.values().iterator();
            while (cptID_itr.hasNext()) {
                CommProcThdID cptID = (CommProcThdID)cptID_itr.next();
                world_elems[world_idx++] = cptID.gthdLineID;
                world_elems[world_idx++] = cptID.wrank;
                comm_elems[comm_idx++] = cptID.gthdLineID;
                comm_elems[comm_idx++] = cptID.icomm;
                comm_elems[comm_idx++] = cptID.rank;
            }
            String[] col_titles = new String[]{"world_rank"};
            YCoordMap world_viewmap = new YCoordMap(num_rows, num_cols4world, "Process View", col_titles, world_elems, null);
            ycoordmap_list.add(world_viewmap);
            col_titles = new String[]{"commID", "comm_rank"};
            YCoordMap comm_viewmap = new YCoordMap(num_rows, num_cols4comm, "Communicator View", col_titles, comm_elems, null);
            ycoordmap_list.add(comm_viewmap);
        }
        return ycoordmap_list;
    }
}

