/*
 * Decompiled with CFR 0.152.
 */
package viewer.timelines;

import base.drawable.Category;
import base.drawable.CategoryWeight;
import base.drawable.Composite;
import base.drawable.Coord;
import base.drawable.Drawable;
import base.drawable.Primitive;
import base.drawable.Shadow;
import base.drawable.Topology;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.tree.TreeNode;
import viewer.common.Const;
import viewer.common.Parameters;
import viewer.common.Routines;
import viewer.legends.CategoryLabel;
import viewer.zoomable.SearchPanel;
import viewer.zoomable.TimeFormat;
import viewer.zoomable.YaxisTreeNode;

public class InfoPanelForDrawable
extends SearchPanel {
    private static final long serialVersionUID = 13100L;
    private static final Component STRUT = Box.createHorizontalStrut(10);
    private static final Component GLUE = Box.createHorizontalGlue();
    private static final String FORMAT = "#,##0.000000####";
    private static DecimalFormat fmt = null;
    private static TimeFormat tfmt = null;
    private static Border Normal_Border = null;
    private static Border Shadow_Border = null;
    private Drawable drawable;

    public InfoPanelForDrawable(Map map_line2treenodes, String[] y_colnames, Drawable dobj) {
        super.setLayout(new BoxLayout(this, 1));
        if (fmt == null) {
            fmt = (DecimalFormat)NumberFormat.getInstance();
            fmt.applyPattern(FORMAT);
        }
        if (tfmt == null) {
            tfmt = new TimeFormat();
        }
        if (Normal_Border == null) {
            Normal_Border = BorderFactory.createEtchedBorder();
        }
        if (Shadow_Border == null) {
            Shadow_Border = BorderFactory.createTitledBorder(Normal_Border, " Preview State ", 1, 2, Const.FONT, Color.magenta);
        }
        this.drawable = dobj;
        Category type = null;
        CategoryLabel label_type = null;
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BoxLayout(top_panel, 0));
        if (this.drawable instanceof Shadow && ((Shadow)this.drawable).getSelectedSubCategory() != null) {
            type = ((Shadow)this.drawable).getSelectedSubCategory();
            label_type = new CategoryLabel(type);
            ((Shadow)this.drawable).clearSelectedSubCategory();
            top_panel.setBorder(Shadow_Border);
        } else {
            type = this.drawable.getCategory();
            label_type = new CategoryLabel(type);
            top_panel.setBorder(Normal_Border);
        }
        top_panel.add(STRUT);
        top_panel.add(label_type);
        top_panel.add(GLUE);
        top_panel.setAlignmentX(0.0f);
        Dimension panel_max_size = top_panel.getPreferredSize();
        panel_max_size.width = Short.MAX_VALUE;
        top_panel.setMaximumSize(panel_max_size);
        super.add(top_panel);
        TextAreaBuffer textbuf = new TextAreaBuffer(map_line2treenodes, y_colnames);
        if (this.drawable instanceof Shadow) {
            textbuf.setShadowText((Shadow)this.drawable, type);
        } else if (this.drawable instanceof Composite) {
            textbuf.setCompositeText((Composite)this.drawable);
        } else {
            textbuf.setPrimitiveText((Primitive)this.drawable);
        }
        textbuf.finalized();
        int num_cols = textbuf.getColumnCount();
        int num_rows = textbuf.getRowCount();
        JTextArea text_area = new JTextArea(textbuf.toString());
        int adj_num_cols = Routines.getAdjNumOfTextColumns(text_area, num_cols);
        num_cols = (int)Math.ceil((double)adj_num_cols * 85.0 / 100.0);
        text_area.setColumns(num_cols);
        text_area.setRows(num_rows);
        text_area.setEditable(false);
        text_area.setLineWrap(true);
        JScrollPane scroller = new JScrollPane(text_area);
        scroller.setAlignmentX(0.0f);
        super.add(scroller);
    }

    public Drawable getSearchedDrawable() {
        return this.drawable;
    }

    private class TextAreaBuffer {
        private Map map_line2treenodes;
        private String[] y_colnames;
        private StringBuffer strbuf;
        private String strbuf2str;
        private int num_cols;
        private int num_rows;

        public TextAreaBuffer(Map in_map_line2treenodes, String[] in_y_colnames) {
            this.map_line2treenodes = in_map_line2treenodes;
            this.y_colnames = in_y_colnames;
            this.strbuf = new StringBuffer();
            this.strbuf2str = null;
            this.num_cols = 0;
            this.num_rows = 0;
        }

        public void finalized() {
            this.strbuf2str = this.strbuf.toString();
            int num_lines = this.getNumOfLines();
            this.num_rows = num_lines <= 3 ? 3 : 4;
        }

        public int getColumnCount() {
            return this.num_cols;
        }

        public int getRowCount() {
            return this.num_rows;
        }

        public String toString() {
            return this.strbuf2str;
        }

        private int getNumOfLines() {
            if (this.strbuf2str != null) {
                int num_lines = 1;
                int ipos = 0;
                int str_length = this.strbuf2str.length();
                while (ipos >= 0 && ipos < str_length) {
                    if ((ipos = this.strbuf2str.indexOf(10, ipos)) < 0) continue;
                    ++num_lines;
                    ++ipos;
                }
                return num_lines;
            }
            return -1;
        }

        private void setCoordsText(Coord[] coords, String description) {
            StringBuffer linebuf = new StringBuffer();
            int coords_length = coords.length;
            if (coords_length > 1) {
                double duration = coords[coords_length - 1].time - coords[0].time;
                linebuf.append("duration" + description + " = " + tfmt.format(duration));
                if (this.num_cols < linebuf.length()) {
                    this.num_cols = linebuf.length();
                }
                ++this.num_rows;
                this.strbuf.append(linebuf.toString() + "\n");
            }
            for (int idx = 0; idx < coords_length; ++idx) {
                linebuf = new StringBuffer("[" + idx + "]: ");
                Coord vertex = coords[idx];
                Integer lineID = new Integer(vertex.lineID);
                YaxisTreeNode node = (YaxisTreeNode)this.map_line2treenodes.get(lineID);
                TreeNode[] nodes = node.getPath();
                linebuf.append("time" + description + " = " + fmt.format(vertex.time));
                for (int ii = 1; ii < nodes.length; ++ii) {
                    linebuf.append(", " + this.y_colnames[ii - 1] + " = " + nodes[ii]);
                }
                if (this.num_cols < linebuf.length()) {
                    this.num_cols = linebuf.length();
                }
                ++this.num_rows;
                this.strbuf.append(linebuf.toString());
                if (idx >= coords_length - 1) continue;
                this.strbuf.append("\n");
            }
        }

        private void setEndCoordsText(Coord start_vtx, Coord final_vtx, double earliest_time, double latest_time, int coords_length) {
            int ii;
            double duration = latest_time - earliest_time;
            StringBuffer linebuf = new StringBuffer();
            linebuf.append("duration (max) = " + tfmt.format(duration));
            if (this.num_cols < linebuf.length()) {
                this.num_cols = linebuf.length();
            }
            ++this.num_rows;
            this.strbuf.append(linebuf.toString());
            int idx = 0;
            linebuf = new StringBuffer("[" + idx + "]: ");
            Coord vertex = start_vtx;
            Integer lineID = new Integer(vertex.lineID);
            YaxisTreeNode node = (YaxisTreeNode)this.map_line2treenodes.get(lineID);
            TreeNode[] nodes = node.getPath();
            linebuf.append("time (min) = " + fmt.format(earliest_time));
            for (ii = 1; ii < nodes.length; ++ii) {
                linebuf.append(", " + this.y_colnames[ii - 1] + " = " + nodes[ii]);
            }
            if (this.num_cols < linebuf.length()) {
                this.num_cols = linebuf.length();
            }
            ++this.num_rows;
            this.strbuf.append("\n" + linebuf.toString());
            idx = coords_length - 1;
            linebuf = new StringBuffer("[" + idx + "]: ");
            vertex = final_vtx;
            lineID = new Integer(vertex.lineID);
            node = (YaxisTreeNode)this.map_line2treenodes.get(lineID);
            nodes = node.getPath();
            linebuf.append("time (max) = " + fmt.format(latest_time));
            for (ii = 1; ii < nodes.length; ++ii) {
                linebuf.append(", " + this.y_colnames[ii - 1] + " = " + nodes[ii]);
            }
            if (this.num_cols < linebuf.length()) {
                this.num_cols = linebuf.length();
            }
            ++this.num_rows;
            this.strbuf.append("\n" + linebuf.toString());
        }

        public void setPrimitiveText(Primitive prime) {
            Drawable prime_parent;
            this.setCoordsText(prime.getVertices(), "");
            String info_str = prime.toInfoBoxString().trim();
            if (info_str.length() > 0) {
                this.strbuf.append("\n" + info_str);
                ++this.num_rows;
            }
            if ((prime_parent = prime.getParent()) != null && (info_str = prime_parent.toInfoBoxString().trim()).length() > 0) {
                this.strbuf.append("\n" + info_str);
                ++this.num_rows;
            }
        }

        private int getPrintStatus(Topology topo) {
            if (topo.isState()) {
                if (Parameters.PREVIEW_STATE_DISPLAY.equals("CumulativeExclusionRatio") || Parameters.PREVIEW_STATE_DISPLAY.equals("OverlapExclusionRatio")) {
                    return 2;
                }
                return 1;
            }
            return 1;
        }

        public void setShadowText(Shadow shade, Category type) {
            this.setEndCoordsText(shade.getStartVertex(), shade.getFinalVertex(), shade.getEarliestTime(), shade.getLatestTime(), shade.getVertices().length);
            this.strbuf.append("\n\n");
            this.setCoordsText(shade.getVertices(), " (ave)");
            this.strbuf.append("\n");
            Topology shade_topo = shade.getCategory().getTopology();
            StringBuffer linebuf = new StringBuffer("Number of Real ");
            linebuf.append(shade_topo + "s = ");
            linebuf.append(shade.getNumOfRealObjects());
            if (this.num_cols < linebuf.length()) {
                this.num_cols = linebuf.length();
            }
            ++this.num_rows;
            this.strbuf.append("\n" + linebuf.toString());
            this.strbuf.append("\n");
            int print_status = this.getPrintStatus(shade_topo);
            this.strbuf.append("\n" + CategoryWeight.getPrintTitle(print_status));
            CategoryWeight[] twgts = shade.arrayOfCategoryWeights();
            for (int idx = 0; idx < twgts.length; ++idx) {
                CategoryWeight twgt = twgts[idx];
                String twgt_str = twgt.toInfoBoxString(print_status);
                if (twgt.getCategory().equals(type)) {
                    if (this.num_cols < (twgt_str = twgt_str + "  <---").length() + 6) {
                        this.num_cols = twgt_str.length() + 6;
                    }
                } else if (this.num_cols < twgt_str.length()) {
                    this.num_cols = twgt_str.length();
                }
                ++this.num_rows;
                this.strbuf.append("\n" + twgt_str);
            }
        }

        public void setCompositeText(Composite cmplx) {
            Drawable cmplx_parent;
            Coord[] cmplx_coords = new Coord[]{cmplx.getStartVertex(), cmplx.getFinalVertex()};
            this.setCoordsText(cmplx_coords, "");
            String info_str = cmplx.toInfoBoxString().trim();
            if (info_str.length() > 0) {
                this.strbuf.append("\n" + info_str);
                ++this.num_rows;
            }
            if ((cmplx_parent = cmplx.getParent()) != null && (info_str = cmplx_parent.toInfoBoxString().trim()).length() > 0) {
                this.strbuf.append("\n" + info_str);
                ++this.num_rows;
            }
        }
    }
}

