
/*
 * $Header: /cvsroot/mpdist/mpdist/mimep/mimep/lineopts.h,v 1.1.1.1 2002/04/12 16:47:26 richbastard Exp $
 * 
 * Copyright (c) Mikael Cam. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MIMEP_LINEOPTS_H__
#define __MIMEP_LINEOPTS_H__

#include <stdio.h>
#include <string.h>
#include "../../common/option.h"

#define bool       char
#define True       1
#define False      0
#define OPTIONID1  '-'
#define OPTIONID2  '+'
#define OPTIONALID '['
#define SPACE      ' '
#define EOS        '\0'
#define OPTEND     ']'
#define POINT      '.'
#define ANDSO      "..."

#define isopt(opt)                getargnum(argc, argv, opt, 0)
#define issubopt(numopt, subopt)  issuboption(argc, argv, numopt, subopt, 0)

int  getargnum                    (int, char **, char *, bool);

void usage                        (char **, char **);

bool iscoherent_com_line          (int, char **, char **, bool);
bool isoption                     (char *);
bool issuboption                  (int, char **, int, char *, bool);

#endif /* __MIMEP_LINEOPTS_H__ */
