
function su_migrate_version()
{
	var had_version = su_ds.isPrefDefined("@client_version");
	var prev_version = su_ds.getPrefValue("@client_version", su_useragent);
	if (had_version && (prev_version == su_useragent))
		return;
	su_ds.setValue("@client_version", su_useragent);
	
	// After upgrading, this routine gets run once.  For a new migration
	// routine:
	// 1: Create a M_[identifier] constant using the next sequential bit
	// 2: OR that bit with the others in the 'if (su_new_install)' block
	// 3: Add the migration routine near the bottom, as indicated by the
	//    comment there.
	// 4: Gate the migration routine using the bit.
	// 5: Be sure to OR the bit at the end of the migration routine.

	const M_PASSWORDS = 0x1;
	const M_IDS = 0x2;
	const M_POSITION = 0x4;
	const M_PREFS_DB = 0x8;
	
	if (su_new_install)
	{
		su_ds.setValue("@client_migration_state", M_PASSWORDS | 
					M_IDS | M_POSITION | M_PREFS_DB);
		su_ds.flushPrefs();
		return;
	}

	su_new_upgrade = true;
	su_prev_version = prev_version;
	su_ds.setValue("@report_error_count", 0);
	su_ds.setValue("@report_error_count_max", su_error_count_max_default);
	if (! su_ds.isPrefDefined("@dd_display_message"))
		su_ds.setValue("@dd_display_message", false);
	
	var migration_bitfield = su_ds.getValue("@client_migration_state");

	try {  // migration can be tricky, so we do a try

	
	if (! (migration_bitfield & M_PASSWORDS))
	{
		// Clear passwords left by old versions.
		su_migrate_clear_old_passwords();
		migration_bitfield |= M_PASSWORDS;
	}

	if (! (migration_bitfield & M_IDS))
	{
		// Fix a bug in version 2.81.
		if ((su_ds.getPrefType("stumble.ids") == "Bool") && (stumbleid != 0))
			su_ds.setValue("@id_list", stumbleid + ":");
		else if (su_ds.getPrefType("stumble.ids") == "Char")
			su_ds.setValue("@id_list", su_ds.getValue("stumble.ids"));

		su_ds.clearPref("stumble.ids");
		migration_bitfield |= M_IDS;
	}

	if (! (migration_bitfield & M_POSITION))
	{
		// Clear passwords left by old versions.
		su_migrate_toolbar_position_scheduled = true;
		migration_bitfield |= M_POSITION;
	}

	if (! (migration_bitfield & M_PREFS_DB))
	{
		// version 3.05
		try {
			su_migrate_contacts_to_prefs();
		}
		catch (e) {
			setTimeout(su_migrate_contacts_to_prefs_delayed, 8000);
		}
		migration_bitfield |= M_PREFS_DB;
	}
	
	// Add each new version migration routine immediately above.

	} catch (e) { try { su_log_error("MIGRATE VERSION", e); } catch (ee) {} }

	su_ds.setValue("@client_migration_state", migration_bitfield)
	su_ds.flushPrefs();
}

// used during init to handle version-specific migration
function su_migrate_profile(new_profile)
{

	var had_version = su_ds.isPrefDefined("$version");
	var prev_version = su_ds.getPrefValue("$version", su_useragent);
	if (had_version && (prev_version == su_useragent))
		return;
	su_ds.setValue("$version", su_useragent);

	// After upgrading, this routine gets run once for each profile,
	// upon the first use of that profile.  For a new migration routine:
	// 1: Create a M_[identifier] constant using the next sequential bit
	// 2: OR that bit with the others in the 'if (su_new_install)' block
	// 3: Add the migration routine near the bottom, as indicated by the
	//    comment there.
	// 4: Gate the migration routine using the bit.
	// 5: Be sure to OR the bit at the end of the migration routine.

	const M_USERAGENT = 0x1;
	const M_SHORTCUTS = 0x2;
	const M_MENU_DEPTH_25 = 0x4;
	const M_INTRO_COUNT = 0x8;
	const M_JSON_CONTACTS_AND_MENU_DEPTH_16 = 0x10;
	const M_HIDE_TAG = 0x20;
	const M_FIX_JSON_CONTACTS = 0x40;
	const M_REFRESH_AVATARS = 0x80;
	const M_INIT_AND_MERGE_BUTTONS = 0x100;
	const M_V3_11 = 0x200;
	const M_V3_15 = 0x400; // 0x400:1024 0x7FF:2047
	const M_V3_16 = 0x800;
	const M_V3_17 = 0x1000;
	
	if (su_new_install || new_profile)
	{
		su_ds.setValue("$migration_state", M_USERAGENT | M_SHORTCUTS | 
					M_MENU_DEPTH_25 | M_INTRO_COUNT | 
					M_JSON_CONTACTS_AND_MENU_DEPTH_16 | M_HIDE_TAG |
					M_FIX_JSON_CONTACTS | M_REFRESH_AVATARS | 
					M_INIT_AND_MERGE_BUTTONS | M_V3_11 | M_V3_15 | M_V3_16 |
					M_V3_17);
		su_ds.flushPrefs();
		return;
	}

	var migration_bitfield = su_ds.getValue("$migration_state");
	
	try {  // migration can be tricky, so we do a try

	
	if (! (migration_bitfield & M_USERAGENT))
	{
		// Reset the useragent of pre-1.9996 clients.
		if (su_ds.isPrefDefined("general.useragent.vendorSub") &&
					(su_ds.getValue("general.useragent.vendorSub").indexOf("StumbleUpon") != -1))
			su_ds.clearPref("general.useragent.vendorSub");
		migration_bitfield |= M_USERAGENT;
	}
	
	if (! (migration_bitfield & M_SHORTCUTS))
	{
		// version <=2.7
		if (su_host.win)
			su_migrate_shortcuts();
		migration_bitfield |= M_SHORTCUTS;
	}

	if (! (migration_bitfield & M_MENU_DEPTH_25))
	{
		// version 2.84
		su_ds.setValue("$sendtos_menu_depth", 25);
		migration_bitfield |= M_MENU_DEPTH_25;
	}

	if (! (migration_bitfield & M_INTRO_COUNT))
	{
		// version 2.87
		su_ds.setValue("$intro_count", 15);
		migration_bitfield |= M_INTRO_COUNT;
	}
	
	if (! (migration_bitfield & M_JSON_CONTACTS_AND_MENU_DEPTH_16))
	{
		// version 2.90
		su_ds.migrateToContacts();
		su_ds.setValue("$sendtos_menu_depth", 16);
		su_ds.flushPrefs();
		migration_bitfield |= M_JSON_CONTACTS_AND_MENU_DEPTH_16;
	}

	if (! (migration_bitfield & M_HIDE_TAG))
	{
		su_ds.setValue("$show_tag", false);
		migration_bitfield |= M_HIDE_TAG;
	}
	
	if (! (migration_bitfield & M_FIX_JSON_CONTACTS))
	{
//		su_ds.fixJSONContacts(false);
		migration_bitfield |= M_FIX_JSON_CONTACTS;
	}

	if (! (migration_bitfield & M_REFRESH_AVATARS))
	{
		su_ds.setValue("$has_avatars", false);
		migration_bitfield |= M_REFRESH_AVATARS;
	}
	
	if (! (migration_bitfield & M_INIT_AND_MERGE_BUTTONS))
	{
		// version 3.07 / 3.08
		su_ds.setValue("$show_groups", su_ds.getValue("$show_groups") || 
					su_ds.getValue("$show_forums"));
		su_ds.setValue("$show_aboutme", su_ds.getValue("$show_aboutme") ||
					su_ds.getValue("$show_mystumblers"));

		su_ds.setValue("$shown_find_friends", true);
		
		migration_bitfield |= M_INIT_AND_MERGE_BUTTONS;
	}
	
	if (! (migration_bitfield & M_V3_11))
	{
		// version 3.11
		if (su_host.dist)
			su_ds.setValue("$show_mode_wiki", true);
		
		var show_searchlinks = su_ds.getValue("$show_searchlinks"); 
		su_ds.setValue("$show_searchlinks_score", show_searchlinks);
		su_ds.setValue("$show_searchlinks_friends", show_searchlinks);
		su_ds.setValue("$show_searchlinks_topic", show_searchlinks);
		su_ds.setValue("$shown_searchlinks", show_searchlinks);
		su_ds.setValue("$show_searchlinks_logo", su_ds.getValue("$searchlink_logos"));
		// pitch social searchlinks to people who have searchlinks disabled
		
		su_ds.setValue("$autocomplete_type", "tag,query");
		
		su_ds.setValue("$show_flag", su_ds.getValue("$show_tag"));
		
		su_get_tags();
		
		if (su_ds.isPrefDefined("$stumblestats") &&
					(su_ds.getValue("$stumblestats") != ""))
		{
			var stumblestats = su_ds.getValue("$stumblestats");
	
			var stumbletypes = "";
			var stumblereferrals = "";
			var first = 0;
			var splitseen = stumblestats.split(".");
			var i;
			for (i = 0; i < splitseen.length; i++)
			{
				if (first == 0)
				{
					first = 1;
				}
				else
				{
					stumbletypes += ".";
					stumblereferrals += ".";
				}
				stumbletypes += "0";
			}
			
			// most profiles were migrated when this was in load_data1()
			if (! su_ds.isPrefDefined("$stumbletypes"))
				su_ds.setValue("$stumbletypes", stumbletypes);
			
			su_ds.setValue("$stumblereferrals", stumblereferrals);
		}
		
		su_check_dyn_channels();
		
		migration_bitfield |= M_V3_11;
	}

	if (! (migration_bitfield & M_V3_15))
	{
		// version 3.15
		
		su_ds.enableFeature("$sociallinks");
		
		// remove ancient legacy contacts
		var contacts = su_ds.getValue("$contacts");
		var i;
		for (i = 0; i < contacts.length; i++)
		{
			var contact = contacts[i];
			if (contact.nickname && (! contact.contactid) &&
						(typeof(contact.fbid) == "undefined"))
				su_ds.deleteRow(contact);
		}
		
		migration_bitfield |= M_V3_15;
	}
		
	if (! (migration_bitfield & M_V3_16))
	{
		var tmpstr = su_ds.getValue("$process_rarely_timestamp");
		if (tmpstr == "")
			su_ds.setValue("$process_rarely_timestamp", "0");
		
		su_check_dyn_channels();
		
		migration_bitfield |= M_V3_16;
	}

	if ((! (migration_bitfield & M_V3_17)) || su_force_migrate_prerelease)
	{
//		if (su_ds.getValue("$shown_find_friends_time_s") == 0)
//			su_ds.setValue("$shown_find_friends_time_s", 2);
		su_ds.setValue("$show_tag", false);
		su_ds.setValue("$show_flag", false);
		su_get_tags();
		clear_stumbles();
		migration_bitfield |= M_V3_17;
	}
	
	// Add each new profile migration routine immediately above.

	} catch (e) { try { su_log_error("MIGRATE PROFILE", e); } catch (ee) {}}
	
	su_ds.setValue("$migration_state", migration_bitfield)
	su_ds.flushPrefs();
}

function su_migrate_contacts_to_prefs_delayed()
{
	try {
		su_migrate_contacts_to_prefs();
	}
	catch (e) {
		su_log_error("MIGRATE CONTACT_DELAYED", e);
		return;
	}
	
	if (stumbleid == 0);
		return;
	
	su_invoke_global_event("refresh-referral-menu", null);
}

function su_migrate_contacts_to_prefs()
{
	var file = su_ds.getResourceNSIFile(null, "json_db")
	if (! file.exists())
		return;
	
	var db = su_ds.deserialize(su_ds.readFile(file));
	if (! db)
		return;
	
	var ids = su_ds.getValue("@id_list").split(":");
	var i;
	for (i = 0; i < ids.length; i++)
	{
		if (ids[i] == "")
			continue;
		
		if (! db[ids[i]])
			continue;
		
		if (! db[ids[i]]["contact"])
			continue;


		var names = su_ds.getPrefNames("stumble." + ids[i] + ".c.");
		if (! names)
			return;
		
		var pref_contacts = new Array();
		var k;
		for (k = 0; k < names.length; k++)
			pref_contacts.push(su_ds.deserialize(su_ds.getValue(names[k])));

		
		var contacts = db[ids[i]]["contact"];
		if (! contacts.constructor != Array)
		{
			// convert to array
			var a = new Array();
			var p;
			for (p in contacts)
			{
				if ((typeof (contacts[p])) == "function")
					continue;
				
				if ((typeof (contacts[p])) == "undefined")				
					continue;
				
				if (contacts[p].constructor == Object)
					a.push(contacts[p]);
			}
			contacts = a;
		}
		
		var j;
		var contact;
		for (j = 0; j < contacts.length; j++)
		{
			var pref_contact = null;
			if (contacts[j].nickname)
			{
				pref_contact = su_get_row(
							pref_contacts,
							"nickname",
							contacts[j].nickname);
			}
			else if (contacts[j].email)
			{
				pref_contact = su_get_row(
							pref_contacts,
							"email",
							contacts[j].email);
			}
			else
			{
				continue;
			}
			
			if (pref_contact)
			{
				contacts[j]._r = pref_contact._r;
			}
			else
			{
				var autoinc_name = "stumble." + ids[i] + ".c_ai";
				contacts[j]._r = su_ds.getPrefValue(autoinc_name, 0);
				su_ds.setValue(autoinc_name, (contacts[j]._r + 1));
			}
			contacts[j]._t = "c";
			var name = "stumble." + ids[i] + ".c." + contacts[j]._r;
			su_ds.setValue(name, su_ds.serialize(contacts[j]));
		}
	}
}

function su_get_row(rows, col_name, value)
{
	var i;
	for (i = 0; i < rows.length; i++)
	{
		if (rows[i][col_name] && (rows[i][col_name] == value))
			return rows[i];
	}
	return null;
}

function su_migrate_clear_old_passwords()
{
	var names = 	su_ds.getPrefNames("stumble.");
	var current_id_pref = "stumble." + 
				su_ds.getValue("@current_user") +
				".password";
	var i;
	for (i = 0; i < names.length; i++)
	{
		if (names[i].indexOf("$password") == -1) continue;
		if (names[i] == current_id_pref) continue;
		su_ds.clearPref(names[i]);
	}
}

function su_migrate_shortcuts()
{
	// If we're on Windows, and if all of the key bindings match the 
	// old defaults, change the bindings to the new defaults. -- JW
	var details = new Array();
	var o;
	
	o = new Object();
	o.oldpref = "$shortcut-stumble";
	o.newpref = "$shortcut_stumble";
	o.oldval = "Alt+VK_F1";
	o.newval = "Alt+VK_BACK_QUOTE";
	details.push(o);
	
	o = new Object();
	o.oldpref = "$shortcut-thumbup";
	o.newpref = "$shortcut_thumbup";
	o.oldval = "Alt+VK_F2";
	o.newval = "Alt+VK_1";
	details.push(o);		
	
	o = new Object();
	o.oldpref = "$shortcut-thumbdown";
	o.newpref = "$shortcut_thumbdown";
	o.oldval = "Alt+VK_F3";
	o.newval = "Alt+VK_2";
	details.push(o);		
	
	o = new Object();
	o.oldpref = "$shortcut-reviews";
	o.newpref = "$shortcut_reviews";
	o.oldval = "Alt+VK_F5";
	o.newval = "Alt+VK_3";
	details.push(o);		
	
	o = new Object();
	o.oldpref = "$shortcut-toolbar";
	o.newpref = "$shortcut_toolbar";
	o.oldval = "Alt+VK_11";
	o.newval = "Alt+VK_11";
	details.push(o);		
	
	var keybindings_edited = false;
	var i;
	for (i = 0; i < details.length; i++)
	{
		if (su_ds.isPrefDefined(details[i].oldpref))
		{
			keybindings_edited = (su_ds.getValue(details[i].oldpref) != details[i].oldval);
			if (keybindings_edited)
			{
				break;
			}
		}
	}
	
	if (keybindings_edited)
	{
		su_init_key_const_dictionaries();

		for (i = 0; i < details.length; i++)
		{
			// This tranlates keyids like " " and "A" to "VK_SPACE" and 
			// "VK_A". -- JW
			var keyspec = su_ds.getValue(details[i].oldpref);
			var parts = keyspec.split("+");
			var old_keyid;
			if (parts[parts.length - 1] == "")
				old_keyid = "+";
			else
				old_keyid = parts[parts.length - 1];

			if (old_keyid.length == 1)
			{
				var new_keyid = su_keyids_by_char[old_keyid];
				if (new_keyid)
				{
					var regexp = new RegExp(su_escape_regexp_chars(old_keyid) + "$");
					keyspec = keyspec.replace(regexp, new_keyid);
				}
			}
			su_ds.setValue(details[i].newpref, keyspec);
		}
	}
}

