<?php

use Moxl\Xec\Action\Register\ChangePassword;
use Moxl\Xec\Action\Register\Remove;
use Moxl\Xec\Action\Register\Get;
use Moxl\Xec\Action\Register\Set;
use Respect\Validation\Validator;

class Account extends \Movim\Widget\Base
{
    public function load()
    {
        $this->addjs('account.js');
        $this->registerEvent('register_changepassword_handle', 'onPasswordChanged');
        $this->registerEvent('register_remove_handle', 'onRemoved');
        $this->registerEvent('register_get_handle', 'onRegister', 'account');
        $this->registerEvent('register_get_error', 'onRegisterError', 'account');
        $this->registerEvent('register_get_errorfeaturenotimplemented', 'onRegisterError', 'account');
        $this->registerEvent('register_set_handle', 'onRegistered', 'account');
        $this->registerEvent('register_set_error', 'onRegisterError', 'account');
    }

    public function onPasswordChanged()
    {
        $this->rpc('Account.resetPassword');
        Notification::toast($this->__('account.password_changed'));

        $this->rpc('Presence_ajaxLogout');
    }

    public function onRemoved()
    {
        $this->user->messages()->delete();
        \App\Post::restrictToMicroblog()->where('server', $this->user->id)->delete();
        $this->rpc('Presence_ajaxLogout');
    }

    public function onRegistered()
    {
        $this->rpc('MovimTpl.fill', '#account_gateways', $this->prepareGateways());
        Notification::toast($this->__('client.registered'));
    }

    public function onRegister($package)
    {
        $content = $package->content;

        $view = $this->tpl();

        if (isset($content->x)) {
            $xml = new \XMPPtoForm;
            $form = $xml->getHTML($content->x);

            $view->assign('form', $form);
            $view->assign('from', $package->from);
            $view->assign('attributes', $content->attributes());
            $view->assign('actions', null);
            if (isset($content->actions)) {
                $view->assign('actions', $content->actions);
            }

            Dialog::fill($view->draw('_account_form'), true);
        }
    }

    public function onRegisterError($packet)
    {
        Notification::toast(
            $packet->content ??
            $this->__('error.oops')
        );
    }

    public function ajaxChangePassword($form)
    {
        $validate = Validator::stringType()->length(6, 40);
        $p1 = $form->password->value;
        $p2 = $form->password_confirmation->value;

        if ($validate->validate($p1)
        && $validate->validate($p2)) {
            if ($p1 == $p2) {
                $arr = explodeJid($this->user->id);

                $cp = new ChangePassword;
                $cp->setTo($arr['server'])
                   ->setUsername($arr['username'])
                   ->setPassword($p1)
                   ->request();
            } else {
                $this->rpc('Account.resetPassword');
                Notification::toast($this->__('account.password_not_same'));
            }
        } else {
            $this->rpc('Account.resetPassword');
            Notification::toast($this->__('account.password_not_valid'));
        }
    }

    public function ajaxRemoveAccount()
    {
        $this->rpc('Presence.clearQuick');
        $view = $this->tpl();
        $view->assign('jid', $this->user->id);
        Dialog::fill($view->draw('_account_remove'));
    }

    public function ajaxClearAccount()
    {
        $view = $this->tpl();
        $view->assign('jid', $this->user->id);
        Dialog::fill($view->draw('_account_clear'));
    }

    public function ajaxClearAccountConfirm()
    {
        $this->onRemoved();
    }

    public function ajaxRemoveAccountConfirm($form)
    {
        if ($form->jid->value == $this->user->id) {
            $da = new Remove;
            $da->request();
        } else {
            Notification::toast($this->__('account.delete_text_error'));
        }
    }

    public function ajaxGetRegistration($server)
    {
        if (!$this->validateServer($server)) {
            return;
        }

        $da = new Get;
        $da->setTo($server)
           ->request();
    }

    public function ajaxRegister($server, $form)
    {
        if (!$this->validateServer($server)) {
            return;
        }
        $s = new Set;
        $s->setTo($server)
          ->setData($form)
          ->request();
    }

    public function prepareGateways()
    {
        $view = $this->tpl();
        $view->assign(
            'gateways',
            \App\Info::where('server', 'like', '%' . $this->user->session->host)
                     ->whereCategory('gateway')
                     ->get()
        );

        return $view->draw('_account_gateways');
    }

    private function validateServer($server)
    {
        return (Validator::stringType()->noWhitespace()->length(6, 80)->validate($server));
    }

    public function display()
    {
        $this->view->assign('gateways', $this->prepareGateways());
    }
}
