//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef RESTORATIONSYSTEM_H
#define RESTORATIONSYSTEM_H

#include <QDialog>

class QListWidget;
class QPushButton;
class QComboBox;
class QLabel;
class QTextBrowser;
class QLineEdit;
class QListWidgetItem;
class QSplitter;
class DiskCore;
class BackUp;

class RestorationSystem : public QDialog
{
	Q_OBJECT
	private slots:
		void setFilter(const QString& filterText);
		void remove();
		void restore();
	public slots:
		void updateTextBrowser(QListWidgetItem *currentItem = 0);
	private:
		DiskCore *core;
	
		QListWidget *listWidget;
		QComboBox *comboBox;
		QTextBrowser *textBrowser;
		QLineEdit *filter;
		QSplitter *splitter;
		QPushButton *removeButton;
		QPushButton *backupButton;

		QString backupsPath;
		QStringList allBackups;
	public:
		RestorationSystem(DiskCore *core,QWidget *parent = 0);
		~RestorationSystem();

		void addBackup(const QString& backup);
		void addBackup(BackUp *backup);
		void saveSettings();
		void loadSettings();
};

#endif
