//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef OPTIONSVIEW_H
#define OPTIONSVIEW_H

#include <QtGui/QTabWidget>
#include <QtCore/QList>

class Option;
class PopupWindow;
class QCheckBox;
class QComboBox;
class QSpinBox;
class PermissionsWidget;
class QLabel;
class DiskDevice;
class QScrollArea;
class QGridLayout;

struct OptionView {
	int type;
	QCheckBox *checkBox;
	QComboBox *comboBox;
	QLabel *label;
	
	// For spin box option
	QLabel *extraLabel;
	QSpinBox *spinBox;
	
	PermissionsWidget *permWidget;
	
	QString source;
	Option *option;
};

class OptionsView : public QTabWidget
{
	Q_OBJECT
	signals:
		void optionChanged();
	public:
		OptionsView(DiskDevice *device,PopupWindow *popupWindow);
		~OptionsView();
	
		
		void addOptions(const QList<Option *>& options,const QString& source);

		enum OptionsTypes { General,Advanced,Ntfs3g,Udf,Iso };
		void showOptions(QList<int> types);
	
		QString getOptions(bool includeDefaultOptions);
	private:
		void addCheckBoxOption(Option *option,const QString& source);
		void addComboBoxOption(Option *option,const QString& source);
		void addSpinBoxOption(Option *option,const QString& source);
		void addPermOption(Option *option,const QString &source);
	
		PopupWindow *popup;
		DiskDevice *device;

		QGridLayout *generalOptionsLayout;
		QGridLayout *advancedOptionsLayout;
		QGridLayout *ntfs3gOptionsLayout;
		QGridLayout *udfOptionsLayout;
		QGridLayout *isoOptionsLayout;
	
		QScrollArea *generalOptionsWidget;
		QScrollArea *advancedOptionsWidget;
		QScrollArea *ntfs3gOptionsWidget;
		QScrollArea *udfOptionsWidget;
	
		QList<OptionView *> options;
		QList<int> shownTabs;
		
		enum OptionType { CheckBox, ComboBox, SpinBox, Perm };
};

#endif
