//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef TREEWIDGET_H
#define TREEWIDGET_H

#include <QTreeWidget>
#include <QString>

class Menu;
class QAction;
class QContextMenuEvent;

// Class which can use special Menu with header
class TreeWidget : public QTreeWidget
{
	Q_OBJECT
	signals:
		void contextMenuEventSignal();
	private:
		Menu *contextMenu;
		bool contextMenuEnabled;
	public:
		TreeWidget(bool contextMenuEnabled = false);
		~TreeWidget();
		void setContextMenuEnabled(bool isEnabled);
		void setContextMenuHeader(const QString &headerText);
		void setContextMenuIcon(const QIcon &icon);
		void addContextMenuAction(QAction *newAction);
		void addContextMenuSeparator();
	protected:
		void contextMenuEvent(QContextMenuEvent *event);
};

#endif
