//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef DOCUMENTATIONDIALOG_H
#define DOCUMENTATIONDIALOG_H

#include <QDialog>
#include <QUrl>

class QPushButton;
class QTextBrowser;
class QListWidget;
class QListWidgetItem;
class QSplitter;

class DocumentationDialog : public QDialog
{
	Q_OBJECT
	private:
		QPushButton *backwardButton;
		QPushButton *forwardButton;
		QPushButton *reloadButton;
		QPushButton *closeButton;
		QTextBrowser *textBrowser;
		QListWidget *listWidget;
		QSplitter *mainWidget;

		QString language;
	private slots:
		void changePage(QListWidgetItem *currentItem,QListWidgetItem *previousItem);
		void sourceChangedSlot(const QUrl& newSource);
	public:
		DocumentationDialog(QWidget *parent = 0);
		~DocumentationDialog();
		void addPoint(const QString& title,const QString& path);

		void saveSettings();
		void loadSettings();
};


#endif
