import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean, Distribution, build_po

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean, build_po=build_po)

setup(name='elisa-plugin-shelf',
    version='0.1', 
    description='Plugin shelf',
    long_description='List all the available UI plugins on a shelf.',
    license='GPL3',
    author='Moovida Developers',
    author_email='elisa@lists.fluendo.com',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['data/*.png', 'data/THANKS']},
    controller_mappings=[('/elisa/shelf',
                          'elisa.plugins.shelf.shelf_controller:ShelfController')],
    cmdclass=cmdclass)
