/* Page text to the user, displaying it with less. */

#include <sys/file.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <moomethod.h>

#include "safetext.c"

int main (int argc, char **argv) {
	int tty;
	FILE *f;
	char **lines;
	int c;
	
	methinit();
	lines = getallvals();

	/* Now that the parameters are read, save them out to .pagefile,
	 * locking it first. */
	umask(066); /* create file mode 600 */
	if ((f = fopen(".pagefile", "a")) == NULL) {
		perror("open .pagefile");
	}
	if (flock(fileno(f), LOCK_EX) != 0) {
		perror("lock .pagefile");
	}
	for (c = 0; lines[c] != NULL; c++) {
		fprintf(f, "%s\n", safen(lines[c]));
		free(lines[c]);
	}
	fflush(f);

	/* The tty is locked for read and write, since less might do both. */
	if ((tty = open("tty", O_RDWR)) == -1) {
		perror("open tty for write");
		exit(1);
	}
	if (flock(tty, LOCK_EX) != 0) {
		perror("flock tty");
		exit(1);
	}
	
	/* Reconnect tty to stdin and stdout. */
	dup2(tty, 0);
	dup2(tty, 1);
	
	/* Set terminal type from term field. */
	setenv("TERM", getfield("term"), 1);
	
	/*
	 * Run less, in secure mode, with options that make it interface
	 * nicely with the test of the moo. And if there is not enough text
	 * to paginate, don't pause. Less will read from stdin, and happily
	 * stdin contains the exact text that less should display -- this
	 * method's "parameters".
	 */
	if (setenv("LESSSECURE", "1", 1) != 0) {
		perror("setenv LESSSECURE=1");
	}
	unsetenv("LESS");
	if (! fork()) {
		execlp("less", "less", "-fqFEGXM", "-PM [More]", ".pagefile", NULL);
		exit(1);
	}
	wait(0);

	ftruncate(fileno(f), 0);
	exit(0);
}
