#include <stdlib.h>
#include <unistd.h>

void run_noembed(int my_argc, char **my_argv, const char *this,
		 const char *moosock, const char *method,
		 const char *mooix_debug) {
	int i;

	/* Set up environment. */
	setenv("THIS", this, 1);
	setenv("MOOSOCK", moosock, 1);
	setenv("METHOD", my_argv[0], 1);
	if (mooix_debug && (*mooix_debug != '\0'))
		setenv("MOOIX_DEBUG", mooix_debug, 1);

	/* execv needs a null at the end of the argument list */
	for(i = 1; i < my_argc - 1; i++) {
		my_argv[i] = my_argv[i + 1];
	}
	my_argv[i] = NULL;

	/* Running method, not argv[0], because this will be called chdired
	 * to the directory the actual method is in. argv[0] has the path
	 * to the method from the object it is called on, which may be
	 * different. */
	execv(method, my_argv);
}
