#!/usr/bin/perl

package Mooix::Session::Socket;
use strict;
use warnings;
use Mooix::Conf;
use Socket;
use base q{Exporter};
our @EXPORT = qw(makesocket);

=head1 NAME

Mooix::Session::Socket - interface to mooix socket session object

=head1 SYNOPSIS

  use Mooix::Session::Socket;

=head1 DESCRIPTION

This is a perl interface to the mooix socket session object.

=head1 METHODS

=over 4

=cut

=item makesocket

Creates the socket used to communicate with the session object, and returns
a file handle open to the socket and ready to accept connections.

=cut

sub makesocket {
	my $session = shift;

	my @ret;
	my $file = $session->id."/socket";
	my $uaddr = sockaddr_un($file);
	my $proto = getprotobyname('tcp');

	my $fd;
	socket($fd, PF_UNIX, SOCK_STREAM, 0) || die "socket: $!";
	unlink($file);
	bind  ($fd, $uaddr) || die "bind: $!";
	listen($fd, SOMAXCONN) || die "listen: $!";

	# sockets must be owned by the mooadmin, and mode 600.
	chown(scalar getpwnam($Mooix::Conf::field{mooadmin}), -1, $file) || die "chown $file: $!";
	chmod(0600, $file) || die "chmod $file: $!";

	return $fd;
}

=back

=head1 COPYRIGHT

Copyright 2003 by Joey Hess <joey@mooix.net>
under the terms of the modified BSD license given in full in the file
COPYRIGHT.

=head1 AUTHOR

Joey Hess <joey@mooix.net>

=cut

1
