/* Tty write method. Written in C for speed. */

#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <ctype.h>
#include <moomethod.h>

#include "safetext.c"

/* Remove xml tags from the text. <sender> is supported; marked up
 * in bold, all else are ignored. Also handle entities. */
char *dexml (char *text) {
	char *ret, *s, *e, *a = NULL;
	int senderunterm=0;
	int len = strlen(text);
	
	if (len == 0)
		return text;
	else
		ret = malloc(len + 1);
	ret[0] = '\0';
	
	while ((s = strchr(text, '<')) || (a = strchr(text, '&'))) {
		if (a) {
			a[0] = '\0';
			a++;
			strcat(ret, text);
			
			e = strchr(a, ';');
			if (! e) {
				strcat(ret, "&");
				text=a;
			}
			else {
				e[0] = '\0';
				if (strcmp(a, "lt") == 0)
					strcat(ret, "<");
				else if (strcmp(a, "gt") == 0)
					strcat(ret, ">");
				else if (strcmp(a, "amp") == 0)
					strcat(ret, "&");
				text=e+1;
			}

			a=NULL;
		}
		else {
			s[0] = '\0';
			s++;
			/* XXX should really escape entities in
			 * here.. */
			strcat(ret, text);
		
			e = strchr(s, '>');
			if (! e) { /* unterminated */
				strcat(ret, text);
				return ret;
			}

			e[0]='\0';
			if (strcmp(s, "sender") == 0) {
				/* XXX hard-coded escape == bad! */
				strcat(ret, "\e[1m");
				senderunterm=1;
			}
			else if (strcmp(s, "/sender") == 0) {
				strcat(ret, "\e[22m");
				senderunterm=0;
			}
		
			text=e+1;
		}
	}

	if (senderunterm)
		strcat(ret, "}");
		
	strcat(ret, text);
	return ret;
}

void dowrite (char **lines, int width, int fd) {
	char *p, *line, *newline;
	int len, c;
	FILE *f = fdopen(fd, "w");
	
	for (c = 0; lines[c] != NULL; c++) {
		line = dexml(safen(lines[c]));
		
		/* The string might consist of multiple lines. So split it
		 * at newlines and work on each piece. */
		do {
			newline = strchr(line, '\n');
			if (newline) {
				newline[0] = '\0';
				newline++;
			}
			
			len = strlen(line);
		
			/* Blank line. */
			if (len == 0) {
				fprintf(f, "\n");
				line = newline;
				continue;
			}
		
			/* Do word-wrapping if necessary. */
			while (len > width) {
				p = line + width;
				while (! isspace(p[0]) && p[0] != '\0' && p > line)
					p--;
				if (p == line) {
					/* Word too long for one line. */
					int c;
					p = line + width;
					c = p[0];
					p[0] = '\0';
					fprintf(f, "%s\n", line);
					p[0] = c;
					len = len - width;
					line = p;
				}
				else {
					p[0]='\0';
					fprintf(f, "%s\n", line);
					len = len - (p - line + 1);
					line = p + 1;
				}
			}
			
			if (len)
				fprintf(f, "%s\n", line);

			line = newline;
		} while (line);
	}
}

int main (int argc, char **argv) {
	int tty, pending;
	struct winsize window_size;
	char **lines;
	
	methinit();
	lines=getallvals();

	if ((tty = open("tty", O_WRONLY)) == -1) {
		perror("open tty for write");
		exit(1);
	}
	
	/* Get tty width. */
	ioctl(tty, TIOCGWINSZ, &window_size);
	
	/* Try to obtain an exclusive lock on the tty. */
	if (flock(tty, LOCK_EX | LOCK_NB) == 0) {
		dowrite(lines, window_size.ws_col, tty);
		return(0);
	}
	
	/* No go, so write the stuff out to the .pending field instead. */
	if ((pending = open(".pending", O_RDWR | O_CREAT | O_APPEND, 0600)) == -1) {
		perror("open .pending");
		exit(1);
	}
	
	if (flock(pending, LOCK_EX) == -1) {
		perror("lock .pending");
		exit(1);
	}
	dowrite(lines, window_size.ws_col, pending);
	return(0);
}
