#!/usr/bin/perl
# This sub returns a pair of filehandles for the locks.
sub getduallock {
	my $this=shift;
	my $locktype=shift;
	my $field=shift;

	my $otherside=$this->otherside;
	
	if (! @otherside) {
		return $this->getlock($locktype, $field);
	}

	# compares their indexes, which are inodes, so never change, so
	# this will always compare the same for any given pair of sides
	if ($this > $otherside) {
		return ($this->getlock($locktype, $field),
			$otherside->getlock($locktype, $field));
	}
	else {
		return ($otheride->getlock($locktype, $field),
			$this->getlock($locktype, $field));
	}
}

1
