"""functions.py
This module implements some extra stand-alone functions to help program the
mooix environment.

This file is part of the Python 2.2.1+ binding for mooix
Copyright (c)2002,2003 Nicholas D. Borko.  All Rights Reserved.
The author can be reached at nick@dd.revealed.net

The Python binding for mooix is free software; you can redistribute
it and/or modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

The Python binding for mooix is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with mooix; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA."""

import os, sys, inspect
from util import *
import variables

# return values for exit
OK, FAIL, SKIP, EXIT, SETIT, SETITREF = 0, 10, 20, 30, 40, 50

def background():
    """background() -> false to parent, true to child

    A convenience function to fork to the background, taking care of
    closing stdin and stdout for the child."""

    if os.fork(): # parent process
        return False
    else:         # child process
        os.close(sys.stdin.fileno())
        os.close(sys.stdout.fileno())
        sys.stdin = open('/dev/null')
        sys.stdout = open('/dev/null', 'w')
        return True

def exit(error = FAIL, new_it = None):
    """exit(error [, new_it])

    error: an error code, one of OK, FAIL, SKIP, EXIT, SETIT, or SETITREF
    new_it: if error is SETIT or SETITREF, then new_it is the new "it"
    
    This function can be used by verbs (and occasional other methods)
    to exit with a numeric exit code that indicates failure, and at the
    same time return a value to the caller."""
    global this_path
    if error == FAIL:
        print '\n'.join( [ '%s\n%s' % ( mooix_parse(k), mooix_parse(v) ) \
                           for k, v in variables.args ])
    elif error == SETIT or error == SETITREF:
        print 'mooix:%s' % (new_it or this_path)
    sys.exit(error)

__all__ = [ 'background', 'exit', 'OK', 'FAIL', 'SKIP', 'EXIT',
            'SETIT', 'SETITREF' ]
