#!/usr/bin/perl -w

=head1 NAME

Mooix::Conf - access to global mooix config file

=head1 SYNOPSIS

 use Mooix::Conf;
 print "system object root is: $Mooix::Conf::field{sysobj}\n";

=head1 DESCRIPTION

This is a simple interface to the global mooix config file.

=cut

package Mooix::Conf;

our %field;

my $sysconfdir=""; # sysconfdir SET AT BUILD TIME

# Load config
sub import {
	open (CONFIG, "<", "$sysconfdir/mooix.conf") ||
		die "$sysconfdir/mooix.conf: $!";
	while (<CONFIG>) {
		chomp;
		next if /^\s*$/ or /\s*#/;

		if (/^([_a-zA-Z]+)="?(.*?)"?\s*$/) { # untaint as we parse
			$field{lc $1}=$2;
		}
	}
}

=head1 COPYRIGHT

Copyright 2001-2003 by Joey Hess <joey@mooix.net>
under the terms of the modified BSD license given in full in the file
COPYRIGHT.

=head1 AUTHOR

Joey Hess <joey@mooix.net>

=cut

1
