#!/usr/bin/perl -w

use strict;

my $file;
my $stockid;
my $stockprop;
my $type;

my %properties;
my %stocks;
my %stockoverride = (
	"Icons.16x16.AboutIcon"           => "Gnome.Stock.About",
	"Icons.16x16.CloseIcon"           => "Gtk.Stock.Close",
	"Icons.16x16.CopyIcon"            => "Gtk.Stock.Copy",
	"Icons.16x16.CutIcon"             => "Gtk.Stock.Cut",
	"Icons.16x16.DeleteIcon"          => "Gtk.Stock.Delete",
	"Icons.16x16.FindIcon"            => "Gtk.Stock.Find",
	"Icons.16x16.HelpIcon"            => "Gtk.Stock.Help",
	"Icons.16x16.NewDocumentIcon"     => "Gtk.Stock.New",
	"Icons.16x16.NextWindowIcon"      => "Gtk.Stock.GoForward",
	"Icons.16x16.OpenFileIcon"        => "Gtk.Stock.Open",
	"Icons.16x16.Options"             => "Gtk.Stock.Preferences",
	"Icons.16x16.PasteIcon"           => "Gtk.Stock.Paste",
	"Icons.16x16.PreView"             => "Gtk.Stock.PrintPreview",
	"Icons.16x16.PrevWindowIcon"      => "Gtk.Stock.GoBack",
	"Icons.16x16.Print"               => "Gtk.Stock.Print",
	"Icons.16x16.QuitIcon"            => "Gtk.Stock.Quit",
	"Icons.16x16.RedoIcon"            => "Gtk.Stock.Redo",
	"Icons.16x16.ReplaceIcon"         => "Gtk.Stock.FindAndReplace",
	"Icons.16x16.RunProgramIcon"      => "Gtk.Stock.Execute",
	"Icons.16x16.SaveAsIcon"          => "Gtk.Stock.SaveAs",
	"Icons.16x16.SaveIcon"            => "Gtk.Stock.Save",
	"Icons.16x16.UndoIcon"            => "Gtk.Stock.Undo",
	"Icons.16x16.Error"               => "Gtk.Stock.DialogError",
	"Icons.16x16.Warning"             => "Gtk.Stock.DialogWarning",
	"Icons.16x16.Information"         => "Gtk.Stock.DialogInfo",
	"Icons.16x16.Question"            => "Gtk.Stock.DialogQuestion",
);



open IN, "/bin/ls |" || die "Can't spawn ls process";

while (<IN>)
{
	chop $_;
	$file = $_;
	next if exists $stockoverride{$file};
	
	$type = `file $file`;
	next unless ($type =~ /PNG image data/);
	
	$type =~ /.+:\s+PNG image data, ([0-9]+) x ([0-9]+)/;
	my ($w, $h) = ($1, $2);
	
	next if ($w > 48 || $h > 48);
	
	# get the property name here
	$stockid = $stockprop = mungename ($file);
	
	# insert dashes to separate words and lowercase everything
	$stockid =~ s/([A-Z])/-$1/g;
	$stockid =~ s/^-//g;
	$stockid =~ tr/A-Z/a-z/;
	
	$stockid = "md-$stockid";
	
	$properties {$stockprop} = "\"$stockid\"";
	push @{$stocks {$stockid}}, $file, $w;
};

print
"//
// THIS CODE IS AUTOGENERATED -- DO NOT MODIFY
// StockIcons.cs
//
// Author: Gustavo Giraldez <gustavo.giraldez\@gmx.net>
//
// Copyright (C) 2004 Gustavo Giraldez.
//

using System;
using System.Collections;
using RS = MonoDevelop.Core.Services.ResourceService;

namespace MonoDevelop.Gui {
	public class Stock {
		internal static void Init ()
		{
";

foreach $stockid (sort keys %stocks) {
	my @alt = @{$stocks {$stockid}};
	
	if ($#alt == 1) {
		$file = $alt[0];
		print
"			RS.AddToIconFactory (\"$stockid\", \"$file\");
";
	} else {
		while ($file = shift @alt) {
			my $w = shift @alt;
			my $size;
			if ($w <= 16) { $size = "Gtk.IconSize.Menu"; }
			elsif ($w <= 18) { $size = "Gtk.IconSize.SmallToolbar"; }
			elsif ($w <= 20) { $size = "Gtk.IconSize.Button"; }
			elsif ($w <= 24) { $size = "Gtk.IconSize.LargeToolbar"; }
			elsif ($w <= 32) { $size = "Gtk.IconSize.Dnd"; }
			else { $size = "Gtk.IconSize.Dialog"; }
			
			print
"			RS.AddToIconFactory (\"$stockid\", \"$file\", $size);
";
	};
    };
};
while (my ($file,$stock) = each %stockoverride) {
	$properties {mungename ($file)} = $stock;
	print
"			RS.AddDefaultStockMapping (\"$file\", $stock);
";
}

print
"		}

";

foreach $stockprop (sort keys %properties) {
	$stockid = $properties {$stockprop};
	
	print
"		public static readonly string $stockprop = $stockid;
";
};

print
"
	}
}
";


sub mungename {
	my $stockid = shift(@_);
	
	# remove noise
	$stockid =~ s/[.]//g;
	$stockid =~ s/Icons//g;
	$stockid =~ s/16x16//g;
	$stockid =~ s/32x32//g;
	
	# titlecase acronyms
	$stockid =~ s/VB/Vb/g;
	$stockid =~ s/JScript/Jscript/g;
	$stockid =~ s/XML/Xml/g;
	$stockid =~ s/HTML/Html/g;
	$stockid =~ s/UML/Html/g;
	$stockid =~ s/UML/Html/g;
	$stockid =~ s/DOS/Dos/g;
	$stockid =~ s/ASP/Asp/g;
	$stockid =~ s/ILD/Ild/g;
	
	# replace invalid characters
	$stockid =~ s/\#/Sharp/g;
	$stockid =~ s/\+\+/PlusPlus/g;
	
	# ucfirst some known whole words
	if ($stockid =~ /^(NETWORK|CDROM|FLOPPY|DRIVE)$/) {
		$stockid = ucfirst lc $stockid;
	}
	return $stockid;
}
