//
// PropertyPadVisitor.cs
//
// Author:
//   Lluis Sanchez Gual
//
// Copyright (C) 2007 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;
using MonoDevelop.Components.Commands;

namespace MonoDevelop.DesignerSupport.PropertyGrid
{
	class PropertyPadVisitor: ICommandTargetVisitor
	{
		public bool Visit (object ob)
		{
			if (ob == null) {
				DesignerSupport.Service.ResetPropertyPad ();
				return true;
			}
			else if (ob is PropertyPad) {
				// Don't change the property grid selection when the focus is inside the property grid itself
				return true;
			}
			else if (ob is IPropertyPadProvider) {
				DesignerSupport.Service.SetPropertyPadContent ((IPropertyPadProvider)ob);
				return true;
			}
			else if (ob is ICustomPropertyPadProvider) {
				DesignerSupport.Service.SetPropertyPadContent ((ICustomPropertyPadProvider)ob);
				return true;
			}
			else
				return false;
		}
	}
}
