/*
 *  monoBristol - Gui for Bristol Synthesiser.
 *
 *
 *  Copyright (C) 2009  David Horvath (dacr@dacr.hu)
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


// MainWindow.cs created with MonoDevelop
// User: dtvonline at 13:05 2009. 05. 15.
//
// To change standard headers go to Edit->Preferences->Coding->Standard Headers
//
using System;
using System.IO;
using System.Xml;
using Gtk;

public partial class MainWindow: Gtk.Window
{	

	public string adriver, ogain, igain, rate;
	public string mdriver, channel;
	public string voices, tcp, preload, period;
	public string mode, param, easydriver;
	public string detune, pwd, velocity, glide;
	public string harmo, glwf, lwf, autoe, autoa;
	
	
	public MainWindow (): base (Gtk.WindowType.Toplevel)
	{
		Build ();
		
		//read config files
		if (System.IO.File.Exists (System.IO.Directory.GetCurrentDirectory() + "/.monobristol.xml")){
			XmlDocument xmlDocument = new XmlDocument();
			xmlDocument.Load(System.IO.Directory.GetCurrentDirectory() + "/.monobristol.xml");

			XmlNodeList importNodes = xmlDocument.SelectNodes("/config/param");

			foreach (XmlNode actualNode in importNodes)
			{
				adriver = actualNode["adriver"].InnerText;
				ogain = actualNode["ogain"].InnerText;
				igain = actualNode["igain"].InnerText;
				rate = actualNode["rate"].InnerText;
				mdriver = actualNode["mdriver"].InnerText;
				channel = actualNode["channel"].InnerText;
				voices = actualNode["voices"].InnerText;
				tcp = actualNode["tcp"].InnerText;
				preload = actualNode["preload"].InnerText;
				period = actualNode["period"].InnerText;
				mode = actualNode["mode"].InnerText;
				easydriver = actualNode["easydriver"].InnerText;
				detune = actualNode["detune"].InnerText;
				pwd = actualNode["pwd"].InnerText;
				velocity = actualNode["velocity"].InnerText;
				glide = actualNode["glide"].InnerText;
				glwf = actualNode["glwf"].InnerText;
				lwf = actualNode["lwf"].InnerText;
				harmo = actualNode["harmo"].InnerText;
				autoe = actualNode["autoe"].InnerText;
				autoa = actualNode["autoa"].InnerText;
				
			//set parameters and update GUI
			if (adriver == "alsa"){
					rbaalsa.Click ();
				}
			if (adriver == "oss"){
					rbaoss.Click ();
				}
			if (adriver == "jack"){
					rbajack.Click ();
				}
			if (mdriver == "alsa"){
					rbmalsa.Click ();
				}
			if (mdriver == "oss"){
					rbmoss.Click ();
				}
			if (mdriver == "seq"){
					rbmseq.Click ();
				}
			if (mdriver == "jack"){
					rbmjack.Click ();
				}
			spingain.Value = Convert.ToDouble(ogain);
			spiningain.Value = Convert.ToDouble(igain);
			entryrate.Text = rate;
			spinchannel1.Value = Convert.ToDouble(channel);
			spinvoices1.Value = Convert.ToDouble(voices);
			entrytcp1.Text = tcp;
			spinpreload.Value = Convert.ToDouble(preload);
			entrycount.Text = period;
			spindetune.Value = Convert.ToDouble(detune);
			entryvelocity.Text = velocity;
			spinglide.Value = Convert.ToDouble(glide);
			spinpitch.Value = Convert.ToDouble(pwd);
			entryharmo.Text = harmo;
			
			if (autoe ==  "1"){
					chautoeasy.Active = true;
				}
			if (autoa == "1"){
					chautoadv.Active = true;
				}
			if (lwf == "1"){
					chautoeasy.Active = true;
				}
			if (glwf == "1"){
					chautoeasy.Active = true;
				}
			
			if (mode == "easy"){
					rbeasy.Click ();
				}
			if (mode == "advanced"){
					rbadv1.Click ();
				}
			if (easydriver == "alsa"){
					rbealsa.Click ();
				}
			if (easydriver == "oss"){
					rbeoss.Click ();
				}
			if (easydriver == "jack"){
					rbejack.Click ();
				}

			}
		}else{
			//generate config file
			bapply.Press ();
		}
	}
	
	protected void OnDeleteEvent (object sender, DeleteEventArgs a)
	{
		Application.Quit ();
		a.RetVal = true;
	}

	//Set synths parameters
	protected void SetMode ()
	{
		if (mode == "easy") {
			param = "-"+easydriver+" -port "+tcp+" -count "+period+" -gain "+ogain+" -ingain "+igain+" -preload "+preload+" -rate "+rate+" -voices "+voices+" -channel "+channel+" -detune "+detune+" -pwd "+pwd+" -velocity "+velocity+" -glide "+glide;
			if (lwf ==  "1"){
				param = param+" -lwf";
			}
			if (glwf == "1"){
				param = param+" -glwf";
			}
			if (harmo != "0"){
				param = param+" -blo "+harmo;
			}
			if (easydriver == "jack"){
			if (autoe == "1"){
				param = param+" -autoconn";
			}
			}
		}
		if (mode == "advanced") {
			param = "-audio "+adriver+" -midi "+mdriver+" -port "+tcp+" -count "+period+" -gain "+ogain+" -ingain "+igain+" -preload "+preload+" -rate "+rate+" -voices "+voices+" -channel "+channel+" -detune "+detune+" -pwd "+pwd+" -velocity "+velocity+" -glide "+glide;
			if (lwf ==  "1"){
				param = param+" -lwf";
			}
			if (glwf == "1"){
				param = param+" -glwf";
			}
			if (harmo != "0"){
				param = param+" -blo "+harmo;
			}
			if (adriver == "jack"){
			if (autoa == "1"){
				param = param+" -autoconn";
			}
			}
		}
	}	
	
	protected virtual void OnBapplyPressed (object sender, System.EventArgs e)
	{
		//check parameters
		if (rbaalsa.Active.ToString () == "True") {
			adriver = "alsa";
		}
		if (rbaoss.Active.ToString () == "True") {
			adriver = "oss";
		}
		if (rbajack.Active.ToString () == "True") {
			adriver = "jack";
		}
		if (rbmalsa.Active.ToString () == "True") {
			mdriver = "alsa";
		}
		if (rbmoss.Active.ToString () == "True") {
			mdriver = "oss";
		}
		if (rbmseq.Active.ToString () == "True") {
			mdriver = "seq";
		}
		if (rbmjack.Active.ToString () == "True") {
			mdriver = "jack";
		}
		ogain = spingain.Text.ToString ();
		igain = spiningain.Text.ToString ();
		rate = entryrate.Text.ToString ();
		channel = spinchannel1.Text.ToString ();
		voices = spinvoices1.Text.ToString ();
		tcp = entrytcp1.Text.ToString ();
		preload = spinpreload.Text.ToString ();
		period = entrycount.Text.ToString ();
		detune = spindetune.Text.ToString ();
		pwd = spinpitch.Text.ToString ();
		velocity = entryvelocity.Text.ToString ();
		glide = spinglide.Text.ToString ();
		harmo = entryharmo.Text.ToString ();
		
		
		if (chautoeasy.Active.ToString () == "True"){
			autoe = "1";
		}else{
			autoe = "0";
		}
		if (chautoadv.Active.ToString () == "True"){
			autoa = "1";
		}else{
			autoa = "0";
		}
		if (chlwf.Active.ToString () == "True"){
			lwf = "1";
		}else{
			lwf = "0";
		}
		if (chglwf.Active.ToString () == "True"){
			glwf = "1";
		}else{
			glwf = "0";
		}
		if (rbeasy.Active.ToString () == "True"){
			mode = "easy";
			rbeasy.Click ();
		}
		if (rbadv1.Active.ToString () == "True"){
			mode = "advanced";
			rbadv1.Click ();
		}
		if (rbealsa.Active.ToString () == "True") {
			easydriver = "alsa";
		}
		if (rbeoss.Active.ToString () == "True") {
			easydriver = "oss";
		}
		if (rbejack.Active.ToString () == "True") {
			easydriver = "jack";
		}
			
		//generate config file
		string config = "<?xml version='1.0' encoding='UTF-8'?><config><param><adriver>"+adriver+"</adriver><adevice></adevice><ogain>"+ogain+"</ogain><igain>"+igain+"</igain><rate>"+rate+"</rate><mdriver>"+mdriver+"</mdriver><mdevice></mdevice><channel>"+channel+"</channel><voices>"+voices+"</voices><tcp>"+tcp+"</tcp><preload>"+preload+"</preload><period>"+period+"</period><mode>"+mode+"</mode><easydriver>"+easydriver+"</easydriver><detune>"+detune+"</detune><pwd>"+pwd+"</pwd><velocity>"+velocity+"</velocity><glide>"+glide+"</glide><harmo>"+harmo+"</harmo><lwf>"+lwf+"</lwf><glwf>"+glwf+"</glwf><autoe>"+autoe+"</autoe><autoa>"+autoa+"</autoa></param></config>";
		System.IO.File.WriteAllText (System.IO.Directory.GetCurrentDirectory() + "/.monobristol.xml", config);
	}
	
	//start synths
	protected virtual void OnBmoogminiPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -mini");
		Console.WriteLine ("startBristol "+param+" -mini");
	}

	protected virtual void OnBmoogvoyagerPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -explorer");
		
	}

	protected virtual void OnBvoybluePressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -voyager");
	}

	protected virtual void OnBmoogmemoPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -memory");
	}

	protected virtual void OnBmoogrealPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -mg1");
	}

	protected virtual void OnBsonicPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -sonic6");
	}

	protected virtual void OnBpro5Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -prophet");
	}

	protected virtual void OnBpro10Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -pro10");
	}

	protected virtual void OnBpro52Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -pro52");
	}

	protected virtual void OnBpro1Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -pro1");
	}

	protected virtual void OnBobxPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -obx");
	}

	protected virtual void OnBobxaPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -obxa");
	}

	protected virtual void OnBaxxePressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -axxe");
	}

	protected virtual void OnBodyPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -odyssey");
	}

	protected virtual void OnB2600Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -arp2600");
	}

	protected virtual void OnBsolinaPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -solina");
	}

	protected virtual void OnBjuno6Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -juno");
	}

	protected virtual void OnBjupiter8Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -jupiter");
	}

	protected virtual void OnBmonopolyPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -monopoly");
	}

	protected virtual void OnBms20Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -ms20");
	}

	protected virtual void OnBpoly800Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -poly800");
	}

	protected virtual void OnBpolysixPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -polysix");
	}

	protected virtual void OnBvoxconPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -vox");
	}

	protected virtual void OnBcon300Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -voxM2");
	}

	protected virtual void OnBb3Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -b3");
	}

	protected virtual void OnBmodulPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -hammond");
	}

	protected virtual void OnBrhode73Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -rhodes");
	}

	protected virtual void OnBrhodebassPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -rhodesbass");
	}

	protected virtual void OnBydxPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -dx");
	}

	protected virtual void OnBcs80Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -cs80");
	}

	protected virtual void OnBbit1Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -bitone");
	}

	protected virtual void OnBbit99Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -bit99");
	}

	protected virtual void OnBbit100Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -bit100");
	}

	protected virtual void OnBroadrunnerPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -roadrunner");
	}

	protected virtual void OnBstratusPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -stratus");
	}

	protected virtual void OnBtrilogyPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -trilogy");
	}

	protected virtual void OnBaksPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -aks");
	}

	protected virtual void OnBbme700Pressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -bme700");
	}

	protected virtual void OnBsidPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -sid");
	}

	protected virtual void OnBmixerPressed (object sender, System.EventArgs e)
	{
		SetMode ();
		System.Diagnostics.Process.Start ("startBristol "+param+" -mixer");
	}

	//set default settings
	protected virtual void OnBdefaultPressed (object sender, System.EventArgs e)
	{
		spingain.Value = 4;
			spiningain.Value = 4;
			entryrate.Text = "44100";
			spinchannel1.Value = 1;
			spinvoices1.Value = 16;
			entrytcp1.Text = "5028";
			spinpreload.Value = 8;
			entrycount.Text = "256";
		spindetune.Value = 0;
		spinpitch.Value = 2;
		spinglide.Value = 5;
		entryvelocity.Text = "510";
		entryharmo.Text = "0";
		rbaalsa.Click ();
		rbeasy.Click ();
		rbealsa.Click ();
		rbmseq.Click ();
		bapply.Press ();
		chlwf.Active = false;
		chglwf.Active = false;
		chautoadv.Active = false;
		chautoeasy.Active = false;
		
	}

	//select mode
	protected virtual void OnRbeasyClicked (object sender, System.EventArgs e)
	{
		rbaalsa.Hide ();
		rbajack.Hide ();
		rbaoss.Hide ();
		rbmalsa.Hide ();
		rbmoss.Hide ();
		rbmseq.Hide ();
		rbmjack.Hide ();
		laudio.Hide ();
		lmidi.Hide ();
		rbealsa.Show ();
		rbeoss.Show ();
		rbejack.Show();
		chautoadv.Hide ();
		chautoeasy.Show ();
	}

	protected virtual void OnRbadv1Clicked (object sender, System.EventArgs e)
	{
		rbaalsa.Show ();
		rbajack.Show ();
		rbaoss.Show ();
		rbmalsa.Show ();
		rbmoss.Show ();
		rbmseq.Show ();
		rbmjack.Show ();
		laudio.Show ();
		lmidi.Show ();
		rbealsa.Hide ();
		rbeoss.Hide ();
		rbejack.Hide ();
		chautoeasy.Hide ();
		chautoadv.Show ();
	}

}