/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.reusables;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import monajat.util.Language_util.LanguageResource;
import monajat.util.Language_util.OreintationHelper;
import sun.awt.VerticalBagLayout;

public class LabeldCheckBoxes extends JPanel implements ActionListener {

	private static final long serialVersionUID = 1L;
	
	private List<JCheckBox> mCheckBoxes;

	public LabeldCheckBoxes(String pName, String... pCheckBoxes) {
		super();
		this.setLayout(new VerticalBagLayout());
		this.mCheckBoxes = new ArrayList<JCheckBox>();
		JPanel aNamePanel = new JPanel();
		final int aColumnsNo = pCheckBoxes.length / 2;
		aNamePanel.setLayout(new GridLayout(aColumnsNo, 3));
		aNamePanel.setBorder(new TitledBorder(LanguageResource.getString(pName)));
		for (String aString : pCheckBoxes) {
			JCheckBox aCheckbox = new JCheckBox(aString);
			this.mCheckBoxes.add(aCheckbox);
			aNamePanel.add(OreintationHelper.setJComponentOreintation(aCheckbox));
			aCheckbox.addActionListener(this);
			aCheckbox.setActionCommand(aString);
		}
		this.add(OreintationHelper.setJComponentOreintation(aNamePanel));
	}

	public void actionPerformed(ActionEvent pEvent) {
		JCheckBox aSourceCheckbox = (JCheckBox) pEvent.getSource();
		boolean aSourceCheckboxStatus = aSourceCheckbox.isSelected();
		if (!aSourceCheckboxStatus) {
			aSourceCheckbox.setSelected(false);
		} else {
			for (JCheckBox aCheckbox : this.mCheckBoxes) {
				if (aCheckbox != aSourceCheckbox) {
					aCheckbox.setSelected(!aSourceCheckboxStatus);
				}
			}
		}
	}
	
}
