/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.main.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingConstants;

import monajat.gui.reusables.FontSetter;
import monajat.util.LoacationSetter;
import monajat.util.PropertyManager;
import monajat.util.Language_util.Language;
import monajat.util.Language_util.LanguageResource;
import monajat.util.Language_util.OreintationHelper;
import sun.awt.VerticalBagLayout;

public class MonajatAbout extends JWindow implements MouseListener {

	private static final long serialVersionUID = 1L;
	
	private JLabel mClose;
	
	private JLabel mAbout;
	
	private JLabel mLicense;

	private JLabel mCredits;
	
	private JPanel mDataPanel;
	
	public MonajatAbout() {
		this.setLayout(new BorderLayout());
		this.setSize(630, 410);
		this.setLocation(LoacationSetter.calculateMiddleLocationOnScreen(getWidth(), getHeight()));
		
		JPanel aUpperPanel = new JPanel();
		aUpperPanel.setBackground(Color.ORANGE);
		JLabel name = new JLabel(LanguageResource.getString("Monajat"));
		FontSetter.setFont(name, 14);
		name.setHorizontalAlignment(SwingConstants.CENTER);
		aUpperPanel.add(name);
		
		JPanel aMainPanel = new JPanel(new BorderLayout());
		aMainPanel.setBackground(Color.DARK_GRAY);
		JPanel aTitlesPanel = new JPanel(new GridLayout(1, 3));
		mLicense = new JLabel("License");
		mLicense.setOpaque(true);
		mLicense.addMouseListener(this);
		FontSetter.setFont(mLicense, 15);
		mLicense.setHorizontalAlignment(SwingConstants.CENTER);
		aTitlesPanel.add(mLicense);
		
		mAbout = new JLabel("About");
		mAbout.setOpaque(true);
		mAbout.setBackground(Color.DARK_GRAY);
		mAbout.setForeground(Color.WHITE);
		mAbout.addMouseListener(this);
		FontSetter.setFont(mAbout, 15);
		mAbout.setHorizontalAlignment(SwingConstants.CENTER);
		aTitlesPanel.add(mAbout);
		
		mCredits = new JLabel("Credits");
		mCredits.setOpaque(true);
		mCredits.addMouseListener(this);
		FontSetter.setFont(mCredits, 15);
		mCredits.setHorizontalAlignment(SwingConstants.CENTER);
		aTitlesPanel.add(mCredits);
		
		mLicense.setBackground(Color.LIGHT_GRAY);
		mLicense.setForeground(Color.BLACK);
		mCredits.setBackground(Color.LIGHT_GRAY);
		mCredits.setForeground(Color.BLACK);
		
		mDataPanel = new JPanel(new GridLayout());
		mDataPanel.setBackground(Color.DARK_GRAY);
		mDataPanel.add(getAboutPanel());
		
		aMainPanel.add(aTitlesPanel, BorderLayout.PAGE_START);
		aMainPanel.add(mDataPanel, BorderLayout.CENTER);
		
		JPanel aLowerPanel = new JPanel();
		aLowerPanel.setBackground(Color.ORANGE);
		mClose = new JLabel(LanguageResource.getString("Close"));
		mClose.addMouseListener(this);
		FontSetter.setFont(mClose, 16);
		mClose.setHorizontalAlignment(SwingConstants.CENTER);
		aLowerPanel.add(mClose);
		
		if (isAlwaysOnTopSupported()) {
			this.setAlwaysOnTop(true);
		}
		this.add(OreintationHelper.setJComponentOreintation(aUpperPanel), BorderLayout.PAGE_START);
		this.add(aMainPanel, BorderLayout.CENTER);
		this.add(OreintationHelper.setJComponentOreintation(aLowerPanel), BorderLayout.PAGE_END);
		this.setVisible(true);
	}

	public static void main(String[] args) {
		Locale default_language = new Locale("ar");
		Language.setCurrentLocale(default_language);
		new MonajatAbout();

	}

	public void mouseClicked(MouseEvent pEvent) {
		if (pEvent.getSource() == mClose) {
			this.dispose();
		} else if (pEvent.getSource() == mAbout) {
			mDataPanel.removeAll();
			mDataPanel.add(getAboutPanel());
			mDataPanel.updateUI();
			mAbout.setBackground(Color.DARK_GRAY);
			mAbout.setForeground(Color.WHITE);
			mLicense.setBackground(Color.LIGHT_GRAY);
			mLicense.setForeground(Color.BLACK);
			mCredits.setBackground(Color.LIGHT_GRAY);
			mCredits.setForeground(Color.BLACK);
		} else if (pEvent.getSource() == mLicense) {
			mDataPanel.removeAll();
			mDataPanel.add(getLicensePanel());
			mDataPanel.updateUI();
			mLicense.setBackground(Color.DARK_GRAY);
			mLicense.setForeground(Color.WHITE);
			mAbout.setBackground(Color.LIGHT_GRAY);
			mAbout.setForeground(Color.BLACK);
			mCredits.setBackground(Color.LIGHT_GRAY);
			mCredits.setForeground(Color.BLACK);
		} else if (pEvent.getSource() == mCredits) {
			mDataPanel.removeAll();
			mDataPanel.add(getCreditsPanel());
			mDataPanel.updateUI();
			mCredits.setBackground(Color.DARK_GRAY);
			mCredits.setForeground(Color.WHITE);
			mLicense.setBackground(Color.LIGHT_GRAY);
			mLicense.setForeground(Color.BLACK);
			mAbout.setBackground(Color.LIGHT_GRAY);
			mAbout.setForeground(Color.BLACK);
		} 
	}
	
	private JPanel getCreditsPanel() {
		JPanel aPanel = new JPanel(new VerticalBagLayout());
		aPanel.setBackground(Color.DARK_GRAY);
		
		JPanel aTitlePanel = new JPanel(new GridLayout(1, 3));
		aTitlePanel.setBackground(Color.DARK_GRAY);
	    aTitlePanel.add(new JLabel(new ImageIcon(PropertyManager.getProperty("picsPath") + "/Doa_64.png")));
	    aTitlePanel.add(paintedLabel("Monajat Credits", 20));
	    aTitlePanel.add(new JLabel(new ImageIcon(PropertyManager.getProperty("picsPath") + "/ubuntume.png")));
	    
	    JPanel aAboutPanel = new JPanel(new GridLayout(17, 1));
	    aAboutPanel.setBackground(Color.DARK_GRAY);
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( " Monajat would like to thank all the people who helped in     ", 14 ));
	    aAboutPanel.add(paintedLabel( " developing, translating and verifying prayers including:       ", 14 ));
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( " Developers:                                                                                  ", 14 ));
	    aAboutPanel.add(paintedLabel( " Ahmad Bouzaien.                                                                         ", 14 ));
	    aAboutPanel.add(paintedLabel( "  ", 14 ));
	    aAboutPanel.add(paintedLabel( " Translators:                                                                                  ", 14 ));
	    JLabel aArabicLabel = paintedLabel( "Arabic   : Mohammad Attieh.                                                ", 14 );
	    aArabicLabel.setIcon(new ImageIcon(PropertyManager.getProperty("picsPath") + "/sa.png"));
	    aAboutPanel.add(aArabicLabel);
	    
	    JLabel aEnglishLabel = paintedLabel( "English : Abdelmonam Kouka.                                             ", 14 );
	    aEnglishLabel.setIcon(new ImageIcon(PropertyManager.getProperty("picsPath") + "/gb.png"));
	    aAboutPanel.add(aEnglishLabel);
	    
	    JLabel aFrenchLabel = paintedLabel( "French : jMehdi.                                                                   ", 14 );
	    aFrenchLabel.setIcon(new ImageIcon(PropertyManager.getProperty("picsPath") + "/fr.png"));
	    aAboutPanel.add(aFrenchLabel);
	    
	    JLabel aPashtoLabel = paintedLabel( "Pashto  : Zabeeh Khan.                                                        ", 14 );
	    aPashtoLabel.setIcon(new ImageIcon(PropertyManager.getProperty("picsPath") + "/af.png"));
	    aAboutPanel.add(aPashtoLabel);
	    
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aPanel.add(aTitlePanel);
	    aPanel.add( aAboutPanel);
		return aPanel;
	}
	
	private JPanel getLicensePanel() {
		JPanel aPanel = new JPanel(new VerticalBagLayout());
		aPanel.setBackground(Color.DARK_GRAY);
		
		JPanel aTitlePanel = new JPanel(new GridLayout(1, 3));
		aTitlePanel.setBackground(Color.DARK_GRAY);
	    aTitlePanel.add(new JLabel(new ImageIcon(PropertyManager.getProperty("picsPath") + "/Doa_64.png")));
	    aTitlePanel.add(paintedLabel("Monajat License", 20));
	    aTitlePanel.add(new JLabel(new ImageIcon(PropertyManager.getProperty("picsPath") + "/ubuntume.png")));
	    
	    JPanel aAboutPanel = new JPanel(new GridLayout(17, 1));
	    aAboutPanel.setBackground(Color.DARK_GRAY);
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( " Monajat is free software; you can redistribute it and/or modify it    ", 14 ));
	    aAboutPanel.add(paintedLabel( " under the terms of the GNU General Public Licence as published  ", 14 ));
	    aAboutPanel.add(paintedLabel( " by the Free Software Foundation; either version 2 of the Licence,", 14 ));
	    aAboutPanel.add(paintedLabel( " or(at your option) any later version.                                                     ", 14 ));
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( " Monajat is distributed in the hope that it will be useful, but             ", 14 ));
	    aAboutPanel.add(paintedLabel( " WITHOUT ANY WARRANTY; without even the implied warranty of    ", 14 ));
	    aAboutPanel.add(paintedLabel( " MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See ", 14 ));
	    aAboutPanel.add(paintedLabel( " the GNU General Public Licence for more details.                             ", 14 ));
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( " You should have received a copy of he GNU General Public           ", 14 ));
	    aAboutPanel.add(paintedLabel( " Licence along with Monajat; if not, write to the Free Software        ", 14 ));
	    aAboutPanel.add(paintedLabel( " Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA           ", 14 ));
	    aAboutPanel.add(paintedLabel( "   02110-1301, USA.                                                                                       ", 14 ));
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aPanel.add(aTitlePanel);
	    aPanel.add( aAboutPanel);
		return aPanel;
	}

	private JPanel getAboutPanel() {
		JPanel aPanel = new JPanel(new VerticalBagLayout());
		aPanel.setBackground(Color.DARK_GRAY);
		
		JPanel aTitlePanel = new JPanel(new GridLayout(1, 3));
		aTitlePanel.setBackground(Color.DARK_GRAY);
	    aTitlePanel.add(new JLabel(new ImageIcon(PropertyManager.getProperty("picsPath") + "/Doa_64.png")));
	    aTitlePanel.add(paintedLabel("About Monajat", 20));
	    aTitlePanel.add(new JLabel(new ImageIcon(PropertyManager.getProperty("picsPath") + "/ubuntume.png")));
	    
	    JPanel aAboutPanel = new JPanel(new GridLayout(15, 1));
	    aAboutPanel.setBackground(Color.DARK_GRAY);
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( "Author        : Monajat is provided by Ubuntu Muslim Edition community.", 14 ));
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( "Copyright   : Monajat is distributed under GPL License v2 or higher.     ", 14 ));
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( "Description: Monajat is a small application that popups prayers every   ", 14 ));
	    aAboutPanel.add(paintedLabel( "                        predetermined period, it works in the tray icon and users  ", 14 ));
	    aAboutPanel.add(paintedLabel( "                        are able to view all the prayers within a self contained        ", 14 ));
	    aAboutPanel.add(paintedLabel( "                        window using next/previous buttons.                                     ", 14 ));
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( "For source code, questions, reporting bugs, and translating:", 14 ));
	    aAboutPanel.add(paintedLabel( "https://launchpad.net/monajat", 14 ));
	    aAboutPanel.add(paintedLabel( "", 14 ));
	    aAboutPanel.add(paintedLabel( "For more information: http://ubuntume.com/monajat", 14 ));
	    aPanel.add(aTitlePanel);
	    aPanel.add( aAboutPanel);
		return aPanel;
	}
	
	private JLabel paintedLabel(String pString, int size) {
		JLabel aLabel = new JLabel(pString);
		FontSetter.setFont(aLabel, size);
		aLabel.setHorizontalAlignment(SwingConstants.CENTER);
		aLabel.setForeground(Color.WHITE);
		return aLabel;
	}
	
	public void mouseEntered(MouseEvent pEvent) {
//		if (pEvent.getSource() == mLicense) {
//			mLicense.setForeground(Color.BLUE);
//		} else if (pEvent.getSource() == mAbout) {
//			mAbout.setForeground(Color.CYAN);
//		} else if (pEvent.getSource() == mCredits) {
//			mCredits.setForeground(Color.CYAN);
//		} 
		
	}

	public void mouseExited(MouseEvent pEvent) {
//		if (pEvent.getSource() == mLicense) {
//			mLicense.setForeground(Color.BLACK);
//		} else if (pEvent.getSource() == mAbout) {
//			mAbout.setForeground(Color.BLACK);
//		} else if (pEvent.getSource() == mCredits) {
//			mCredits.setForeground(Color.BLACK);
//		} 
		
	}

	public void mousePressed(MouseEvent pEvent) {
		
	}

	public void mouseReleased(MouseEvent pEvent) {
		
	}

}
