/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.main;

import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import monajat.gui.reusables.LabeldComboBox;
import monajat.gui.reusables.LabeldSpinner;
import monajat.util.PropertyManager;
import sun.awt.VerticalBagLayout;

public class LookPanel extends JPanel {

	private static final long serialVersionUID = 1L;
	
	private LabeldSpinner showEveryFor;

	private LabeldSpinner showForBox;
	
	private LabeldComboBox langaugeBox;
	
	public LookPanel(String... aSupportedLanguages) {
		super();
		this.setLayout(new VerticalBagLayout());
		this.setBorder(new EmptyBorder(30, 30, 30, 30));
		String[] aDelay = new String[59];
		for (int i = 1; i < 60; i++) {
			aDelay[i-1] = i+"";
		}
		/////////////
		String  dlanguage = "Arabic";
		int dshowevey = 5,dshowfor = 10;
		if (PropertyManager.getProperty("language") != null && PropertyManager.getProperty("language").length() > 0) {
			dlanguage = PropertyManager.getProperty("language");
		}
		if (PropertyManager.getProperty("show_every") != null && PropertyManager.getProperty("show_every").length() > 0) {
			dshowevey=Integer.parseInt(PropertyManager.getProperty("show_every"));
		}
		if (PropertyManager.getProperty("show_for") != null && PropertyManager.getProperty("show_for").length() > 0) {
			dshowfor=Integer.parseInt(PropertyManager.getProperty("show_for"));	     	
		}
		
		
		
		
		/////////////
		String[] Languages = new String[] {"", "Arabic", "English", "French", "German", "Dutch (NL)", "Pashto"};
		langaugeBox = new LabeldComboBox("Language : ",dlanguage, Languages);
		showEveryFor = new LabeldSpinner("Show prayer Every (min): ",dshowevey, aDelay);
		showForBox = new LabeldSpinner("Show prayer for (sec): ",dshowfor, aDelay);
		this.add(showEveryFor);
		this.add(showForBox);
		this.add(langaugeBox);
	}

	public Object getLangauge() {
		return langaugeBox.getNamedComboBox().getSelectedItem();
	}

	public Object getShowEvery() {
		return showEveryFor.getNamedJSpinner().getValue();
	}

	public Object getshowFor() {
		return showForBox.getNamedJSpinner().getValue();
	}
}
