/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingConstants;

import monajat.doa.Doa;
import monajat.doa.DoaLoader;
import monajat.doa.DoaReader;
import monajat.gui.reusables.FontSetter;
import monajat.util.LoacationSetter;
import monajat.util.PropertyManager;
import monajat.util.Language_util.LanguageResource;
import monajat.util.Language_util.OreintationHelper;

public class FullMode extends JWindow implements MouseListener {

	private static final long serialVersionUID = 1L;

	private JLabel mClose;
	
	private JLabel mSize;
	
	private JLabel mNext;
	
	private JLabel mPrevious;
	
	private JPanel mMainPanel;
	
	private List<File> mDoaList = new ArrayList<File>();
	
	private int mDoaCount;
	
	private DoaReader mDoaReader;
	
//	public static void main(String[] args) {
//		Locale default_language = new Locale("ar");
//		Language.setCurrentLocale(default_language);
//		new FullMode();
//	}
	
	public FullMode() {
		this.setLayout(new BorderLayout());
		this.setSize(600, 400);
		this.setLocation(LoacationSetter.calculateMiddleLocationOnScreen(getWidth(), getHeight()));
		
		mDoaList = DoaLoader.loadDoa();
		mDoaCount = 0;
		mDoaReader = new DoaReader();
		
		JPanel aUpperPanel = new JPanel();
		aUpperPanel.setLayout(new GridLayout(1, 3));
		mClose = new JLabel(LanguageResource.getString("Close"));
		mClose.addMouseListener(this);
		FontSetter.setFont(mClose, 13);
		mClose.setHorizontalAlignment(SwingConstants.CENTER);
		aUpperPanel.setBackground(Color.ORANGE);
		mSize = new JLabel(LanguageResource.getString("Maximize"));
		mSize.addMouseListener(this);
		FontSetter.setFont(mSize, 13);
		mSize.setHorizontalAlignment(SwingConstants.CENTER);
		JLabel name = new JLabel(LanguageResource.getString("Monajat"));
		FontSetter.setFont(name, 13);
		name.setHorizontalAlignment(SwingConstants.CENTER);
		aUpperPanel.add(mSize);
		aUpperPanel.add(name);
		aUpperPanel.add(mClose);
		
		mMainPanel = new JPanel(new BorderLayout());
		mMainPanel.setBackground(Color.GRAY);
		JPanel aMainPanelHeader = new JPanel(new GridLayout(1, 3));
		mNext = new JLabel(new ImageIcon(PropertyManager.getProperty("picsPath") + "/next.png"));
		mNext.addMouseListener(this);
		mNext.setBackground(Color.GRAY);
		FontSetter.setFont(mNext, 13);
		mNext.setHorizontalAlignment(SwingConstants.CENTER);
		aMainPanelHeader.setBackground(Color.GRAY);
		mPrevious = new JLabel(new ImageIcon(PropertyManager.getProperty("picsPath") + "/previous.png"));
		mPrevious.addMouseListener(this);
		mPrevious.setBackground(Color.GRAY);
		FontSetter.setFont(mPrevious, 13);
		mPrevious.setHorizontalAlignment(SwingConstants.CENTER);
		aMainPanelHeader.add(mPrevious);
		
		aMainPanelHeader.add(mPrevious);
		aMainPanelHeader.add(new JLabel(new ImageIcon(PropertyManager.getProperty("picsPath") + "/Doa2.png")));
		aMainPanelHeader.add(mNext);
		mMainPanel.add(aMainPanelHeader, BorderLayout.PAGE_START);
		Doa aDoa = mDoaReader.getDoa(mDoaList.get(mDoaCount));
		mMainPanel.add(getDoaPanel(aDoa), BorderLayout.CENTER);
		if (isAlwaysOnTopSupported()) {
			this.setAlwaysOnTop(true);
		}
		this.add(OreintationHelper.setJComponentOreintation(aUpperPanel), BorderLayout.PAGE_START);
		this.add(OreintationHelper.setJComponentOreintation(mMainPanel), BorderLayout.CENTER);
		this.setVisible(true);
	}
	
	public void nextDoa() {
		if (mDoaCount == mDoaList.size()-1) {
			mDoaCount = -1;
		}
		mMainPanel.remove(1);
		Doa aDoa = mDoaReader.getDoa(mDoaList.get(++mDoaCount));
		if (aDoa != null) {
			mMainPanel.add(getDoaPanel(aDoa), BorderLayout.CENTER);
		} else {
			while(aDoa == null) {
				if (mDoaCount == mDoaList.size()-1) {
					mDoaCount = -1;
				}
				aDoa = mDoaReader.getDoa(mDoaList.get(++mDoaCount));
			}
			mMainPanel.add(getDoaPanel(aDoa), BorderLayout.CENTER);
		}
		mMainPanel.updateUI();
	}
	public void previousDoa() {
		if (mDoaCount == 0) {
			mDoaCount = mDoaList.size();
		}
		Doa aDoa = mDoaReader.getDoa(mDoaList.get(--mDoaCount));
		mMainPanel.remove(1);
		if (aDoa != null) {
			mMainPanel.add(getDoaPanel(aDoa), BorderLayout.CENTER);
		} else {
			while(aDoa == null) {
				if (mDoaCount == 0) {
					mDoaCount = mDoaList.size();
				}
				aDoa = mDoaReader.getDoa(mDoaList.get(--mDoaCount));
			}
			mMainPanel.add(getDoaPanel(aDoa), BorderLayout.CENTER);
		}
		mMainPanel.updateUI();
	}
	
	public JPanel getDoaPanel(Doa doa) {
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(doa.getMDoaContent().size() + 4, 1));
		mainPanel.setBackground(new Color(64, 64, 64));
		mainPanel.add(new JLabel(""));
		for (String string : doa.getMDoaContent()) {
			JLabel aLabel = new JLabel(string);
			FontSetter.setFont(aLabel, 16);
			aLabel.setHorizontalAlignment(SwingConstants.CENTER);
			aLabel.setForeground(Color.WHITE);
			mainPanel.add(aLabel);
		}
		mainPanel.add(new JLabel(""));
		JLabel aLabel = new JLabel(doa.getMDescription());
		FontSetter.setFont(aLabel, 16);
		aLabel.setHorizontalAlignment(SwingConstants.CENTER);
		aLabel.setForeground(Color.WHITE);
		mainPanel.add(aLabel);
		mainPanel.add(new JLabel(""));
		return mainPanel;
	}
	
	public void mouseClicked(MouseEvent pEvent) {
		if (pEvent.getSource() == mClose) {
			this.dispose();
		} else if (pEvent.getSource() == mSize) {
			if (this.mSize.getText().equalsIgnoreCase(LanguageResource.getString("Maximize"))) {
				this.setSize(800, 600);
				this.setLocation(LoacationSetter.calculateMiddleLocationOnScreen(getWidth(), getHeight()));
				this.mSize.setText(LanguageResource.getString("Minimize"));
			} else {
				this.setSize(600, 400);
				this.setLocation(LoacationSetter.calculateMiddleLocationOnScreen(getWidth(), getHeight()));
				this.mSize.setText(LanguageResource.getString("Maximize"));
			}
		} else if (pEvent.getSource() == mNext) {
			nextDoa();
		} else if (pEvent.getSource() == mPrevious) {
			previousDoa();
		}
	}

	public void mouseEntered(MouseEvent pEvent) {
		if (pEvent.getSource() == mPrevious) {
			mPrevious.setForeground(Color.CYAN);
		} else if (pEvent.getSource() == mNext) {
			mNext.setForeground(Color.CYAN);
		} else if (pEvent.getSource() == mClose) {
			mClose.setForeground(Color.LIGHT_GRAY);
		} else if (pEvent.getSource() == mSize) {
			mSize.setForeground(Color.LIGHT_GRAY);
		}
		
	}

	public void mouseExited(MouseEvent pEvent) {
		if (pEvent.getSource() == mPrevious) {
			mPrevious.setForeground(Color.WHITE);
		} else if (pEvent.getSource() == mNext) {
			mNext.setForeground(Color.WHITE);
		} else if (pEvent.getSource() == mClose) {
			mClose.setForeground(Color.BLACK);
		} else if (pEvent.getSource() == mSize) {
			mSize.setForeground(Color.BLACK);
		}
	}

	public void mousePressed(MouseEvent pE) {
		// TODO Auto-generated method stub
		
	}

	public void mouseReleased(MouseEvent pE) {
		// TODO Auto-generated method stub
		
	}

}
