/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.gui.main;

import java.util.List;

import javax.swing.JPanel;
import javax.swing.JRadioButton;

import monajat.gui.reusables.LabeldRadioButtons;
import monajat.util.Language_util.OreintationHelper;

public class DestinationPanel extends JPanel {

	private static final long serialVersionUID = 1L;
	
	public DestinationPanel() {
		super();
		this.add(new LabeldRadioButtons("place on screen : ", new String[] {"", "", "", "" , "", "", "", "", ""}));
		OreintationHelper.setJComponentOreintation(this);
	}
	
	public int getDestination() {
		List<JRadioButton> aList = ((LabeldRadioButtons) this.getComponent(0)).getCheckBoxes();
		for (int i = 0; i < aList.size(); i++) {
			JRadioButton aButton = (JRadioButton) aList.get(i);
			if (aButton.isSelected()) {
				return i;
			}
		}
		return 4;
	}

}
