%define xmmsinputdir  %(xmms-config --input-plugin-dir)
%define xmmsdatadr     %(xmms-config --data-dir)

%define name     modplugxmms
%define version  2.04
%define release  kb1

%define libname  libmodplug
%define major    0

%define samplename modplugplay

Name: %{name}
Summary: Modplug-xmms Mod file playing plugin for XMMS using libmodplug
Version: %{version}
Release: %{release}
License: Public Domain
Epoch: 1
Group: System Environment/Libraries
URL: http://modplug-xmms.sourceforge.net/
Source: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}
Requires: xmms >= 1.0.0, glib >= 1.2.7, gtk+ >= 1.2.7, %{libname}%{major} = %version
BuildPrereq: xmms-devel

%description
Modplug-XMMS is a fully featured, complete input plugin for XMMS which
plays mod-like music formats. It is based on the mod rendering code from
ModPlug, a popular windows mod player written by Olivier Lapicque,
found at http://www.modplug.com

%package -n %{samplename}
Group: Applications/Multimedia
Summary: Text Mode Mod Player

%description -n %{samplename}
A texted based Mod Player based on the modplug mod playing music library.

%package -n %{libname}%{major}
Group: Development/Libraries
Summary: Libmodplug library - decoder for mod files.

%description -n %{libname}%{major}
This is the shared library part of the Modplug music player.

%package -n %{libname}%{major}-devel
Group: Deveopment/Libraries
Summary: Header files for compiling against Modplug library.
Provides:	%{libname}-devel = %version
Requires:	%{libname}%{major} = %version

%description -n %{libname}%{major}-devel
This is the development package of libmodplug. Install it if you want to 
compile programs using this library.

%prep
rm -rf $RPM_BUILD_ROOT

%setup -q

%build
libtoolize --force
automake
autoconf
%configure
make

%install
rm -rf %{buildroot}
make install DESTDIR=$RPM_BUILD_ROOT 

%clean
rm -rf %{buildroot}

%post -n %{libname}%{major} -p /sbin/ldconfig
%postun -n %{libname}%{major} -p /sbin/ldconfig

%files -n %{libname}%{major}
%defattr(-,root,root)
%doc libmodplug/README COPYING
%{_libdir}/libmodplug.so.*

%files -n %{libname}%{major}-devel
%defattr(-,root,root)
%doc libmodplug/changes.txt COPYING
%{_libdir}/libmodplug.la
%{_includedir}/modplug.h
%{_libdir}/xmms/Input/libmodplugxmms.la

%files -n %{samplename}
%defattr(-,root,root)
%{_bindir}/modplugplay

%files
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog README TODO
%{_libdir}/xmms/Input/libmodplugxmms.so

%changelog
* Tue Apr 29 2003 Konstanty Bialkowski <konstanty@ieee.org>
- Included Modplug play - command line library
- Synced to latest modplugxmms package

* Sun Jul 21 2002 Konstanty Bialkowski <konstanty@ieee.org>
- Nicer description
- Fixes to build process
- lib is now under seperate package name
- (Thanks to Goetz Waschk, and his Mandrake package .spec file)

* Sun Jul 21 2002 Konstanty Bialkowski <konstanty@ieee.org>
- Initial RPM 

