/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: mlist.h,v 1.16 2002/09/26 13:10:20 ostborn Exp $
*/

#ifndef _M_LIST_H_
#define _M_LIST_H_

#include <zlib.h>
#include <stdio.h>

#include "config.h"
#include "mdatatypes.h"

typedef struct _mlist{
	mdata *data;
	struct _mlist *next;
	struct _mlist *prev;
} mlist;

mlist * mlist_init ();
int mlist_free_entry(mlist *l);
int mlist_free(mlist *l);
int mlist_insert (mlist *lstp, mdata *ins_data);
int mlist_insert_replace (mlist *lstp, mdata *ins_data);
int mlist_insert_sorted (mlist *l, mdata *ins_data);
int mlist_append (mlist *lstp, mdata *ins_data);
int mlist_write(gzFile *fd, mlist *l);
int mlist_count(mlist *l);

mlist* mlist_sort_full_by_string (mlist *l);
mlist* mlist_sort_limited_by_string (mlist *l, int count);


int mlist_in_list(mlist *l, const char *str);
mdata *mlist_get_data(mlist *l, const char *str);
int mlist_sumup(mlist *l);
double mlist_sumup_vcount(mlist *l);

#endif
