/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.18 2002/11/06 14:18:59 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <zlib.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"
#include "mconfig.h"

/* begin of SubList */

int mdata_SubList_to_xml(gzFile *fd, mdata *data) {
#define WR(x,f) \
	gzprintf(fd, "<%s>%"#f"</%s>\n", #x, data->data.sublist.x, #x);

	WR(count, d);

	gzprintf(fd, "<sublist>\n");
	mlist_write(fd, data->data.sublist.sublist);
	gzprintf(fd, "</sublist>\n");
#undef WR
	return 0;
}

int mdata_SubList_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_SUBLIST) return -1;

	if (data->data.sublist.sublist) mlist_free(data->data.sublist.sublist);

	return 0;
}

int mdata_SubList_setdata(mdata *data, const char *str, mlist *list, int count) {

	data->key = strdup(str);
	assert(data->key);

	data->data.sublist.sublist = list ? list : mlist_init();
	data->data.sublist.count   = count;

	if (data->type == M_DATA_TYPE_UNSET)
		data->type = M_DATA_TYPE_SUBLIST;

	return 0;
}

int mdata_SubList_from_xml(void *user_data, int tagtype, const xmlChar *value, const xmlChar **attrs) {
	int i;
	static mdata_values data_values[] = {
		{ "count", M_DATA_FIELDTYPE_LONG  },
		{ "sublist", M_DATA_FIELDTYPE_LIST },

		{ NULL, M_DATA_FIELDTYPE_UNSET }
	};

	mstate_stack *m = user_data;

//	M_WP();

	switch(tagtype) {
	case M_TAG_BEGIN:
		for (i = 0; data_values[i].string != NULL && 0 != strcmp(data_values[i].string, value); i++)
			;

		if (data_values[i].string == NULL) {
			M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
				 "unknown tag '%s'\n",
				 value);
			return -1;
		}
#define SET_DATA(x) \
	m->st[m->st_depth].data = &(((mdata *)(m->st[m->st_depth-1].data))->x);
		switch(i) {
		case 0: SET_DATA(data.sublist.count); break;
		case 1: m->st[m->st_depth].data = (((mdata *)(m->st[m->st_depth-1].data))->data.sublist.sublist) = mlist_init();
//			fprintf(stderr, "%s: %p\n", __FUNCTION__, m->st[m->st_depth].data);
			break;
		default:
			return -1;
		}
#undef SET_DATA
		/* the same for all 4 values */
		m->st[m->st_depth].function = mdata_insert_value;
		m->st[m->st_depth].type = data_values[i].type;

		break;
	case M_TAG_END:
		((mdata *)(m->st[m->st_depth-1].data))->type = M_DATA_TYPE_SUBLIST;

		switch(m->st[m->st_depth-2].type) {
		case M_DATA_FIELDTYPE_HASH: {
			mhash *h = m->st[m->st_depth-2].data;
			mdata *data = m->st[m->st_depth-1].data;
			mlist *l;
#if 0
			for (l = data->data.sublist.sublist; l && l->data; l = l->next) {
				char *die = NULL;

				/* safety crash */
				if (l->data->data.brokenlink.timestamp< 100000000L) {
					fprintf(stderr, "%s.%d: %d, %s\n",
						__FILE__, __LINE__,
						data->type, data->key);
					fprintf(stderr, "%s.%d: %d, %s, %d, %ld\n",
						__FILE__, __LINE__,
						l->data->type, l->data->key, l->data->type, l->data->data.brokenlink.timestamp);
					*die = 0;
				}
			}
#endif
			mhash_insert_sorted(h, data);
			break;
		}
		default:
			M_WP();
		}

		break;
	case M_TAG_TEXT:
		M_WP();
		break;
	default:
		M_DEBUG1(M_DEBUG_LEVEL_ERRORS, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "can't handle tagtype '%d'\n",
			 tagtype);
		return -1;
	}

	return 0;
}



int mdata_SubList_append(mdata *dst, mdata *src) {
	dst->data.sublist.count += src->data.sublist.count;

	return 0;
}

mdata *mdata_SubList_init() {
	mdata *data = mdata_init();
	assert(data);

	data->key		= NULL;
	data->type		= M_DATA_TYPE_SUBLIST;

#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */
	data->data.sublist.sublist	= NULL;
	data->data.sublist.count	= 0;

	return data;
}

mdata *mdata_SubList_copy(mdata *src) {
	mdata *data = mdata_SubList_init();
	assert(data);
	mdata_SubList_setdata(data, src->key, src->data.sublist.sublist, src->data.sublist.count);

	return data;
}

mdata *mdata_SubList_create(const char *str, mlist *list) {
	mdata *data = mdata_SubList_init();
	assert(data);
	mdata_SubList_setdata(data, str, list, 1);

	return data;
}

/* end of SubList */
