#ifndef _BUFFER_H_
#define _BUFFER_H_

#include <sys/types.h>

typedef struct {
	char *ptr;
	size_t used;
	size_t size;
} buffer;

buffer* buffer_init();
void buffer_free(buffer *b);
int buffer_prepare_copy(buffer *b, size_t size);
int buffer_prepare_append(buffer *b, size_t size);
int buffer_strcpy(buffer *b, const char *s);
int buffer_strcpy_len(buffer *b, const char *s, size_t s_len);
int buffer_strcat(buffer *b, const char *s);
int buffer_strcat_len(buffer *b, const char *s, size_t s_len);

int ultostr(char *s, unsigned long l);
int ultohex(char *s, unsigned long l);
int ltostr(char *s, long l);

#endif
