/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.c,v 1.6 2003/04/18 18:40:41 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

/* this code is taken from the squid plugin */

/* init the plugin */

int mplugins_input_pureftpd_dlinit(mconfig *ext_conf) {
	config_input *conf = NULL;
	const char *errptr;
	int erroffset = 0;

	if (0 != strcmp(ext_conf->version, VERSION)) {
		M_DEBUG2(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
			 "version string doesn't match: (mla) %s != (plugin) %s\n", ext_conf->version, VERSION);
		return -1;
	}

/* get the neccesary space */
	conf = malloc(sizeof(config_input));
	memset(conf, 0, sizeof(config_input));

/* set some defaults */
	conf->inputfilename = NULL;
	
	/* will be replaced by setdefaults if we have a real inputfilename */
	conf->buf = buffer_init();

/* compile the match */
	if ((conf->match_pureftpd = pcre_compile(
		/*timestamp   sess-id     host  Down/Upload
		                    user             xfersize */
		"^([0-9]{9,}) (.+?) (.+?) (.+?) ([DU]) ([0-9]+) "
		/* duration
 		          filename    */
		"([0-9]+) (.+)$",
		0, &errptr, &erroffset, NULL)) == NULL) {

		fprintf(stderr, "%s.%d: rexexp compilation error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

	conf->match_pureftpd_extra = pcre_study(conf->match_pureftpd, 0, &errptr);
	if (errptr != NULL) {
		fprintf(stderr, "%s.%d: rexexp studying error at %s\n", __FILE__, __LINE__, errptr);
		return -1;
	}

/* connect the plugin config to the master config */
	ext_conf->plugin_conf = conf;

	return 0;
}

/* destructor */

int mplugins_input_pureftpd_dlclose(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;
	
	mclose(&(conf->inputfile));

	buffer_free(conf->buf);

	free(ext_conf->plugin_conf);
	ext_conf->plugin_conf = NULL;

	return 0;
}

int mplugins_input_pureftpd_parse_config(mconfig *ext_conf, const char *filename, const char *section) {
	config_input *conf = ext_conf->plugin_conf;

	const mconfig_values config_values[] = {
		{"inputfile",	M_CONFIG_TYPE_STRING,	M_CONFIG_VALUE_OVERWRITE, &(conf->inputfilename)},

		{NULL, M_CONFIG_TYPE_INT, 0, NULL}
	};

	return mconfig_parse_section(ext_conf, filename, section, config_values);
}


int mplugins_input_pureftpd_set_defaults(mconfig *ext_conf) {
	config_input *conf = ext_conf->plugin_conf;
	
	if (conf->inputfilename && strcmp(conf->inputfilename, "-") != 0) {
		if (mopen(&(conf->inputfile), conf->inputfilename)) {
			M_DEBUG2(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
				 "%s: %s\n", conf->inputfilename, strerror(errno));
			return -1;
		}
		M_DEBUG1(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_VERBOSE,
			 "(pureftpd) using %s as inputfile\n", conf->inputfilename);
	} else {
		/* stdin */
		if (mopen(&(conf->inputfile), NULL)) {
			M_DEBUG2(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_ERRORS,
				 "%s: %s\n", conf->inputfilename, strerror(errno));
			return -1;
		}
		
		M_DEBUG0(ext_conf->debug_level, M_DEBUG_SECTION_INIT, M_DEBUG_LEVEL_VERBOSE,
			 "(pureftpd) using (stdin) as inputfile\n");
	}

	return 0;
}


int mplugins_init(mplugin *func) {
	func->dlinit = mplugins_input_pureftpd_dlinit;
	func->dlclose = mplugins_input_pureftpd_dlclose;
	func->parse_config = mplugins_input_pureftpd_parse_config;
	func->set_defaults = mplugins_input_pureftpd_set_defaults;
	func->get_next_record = mplugins_input_pureftpd_get_next_record;
	func->insert_record = NULL;
	func->gen_report = NULL;
        func->gen_history = NULL;

	return 0;
}
