/* 
 * encoding3548.h - RFC 3548 encodings
 *
 * Copyright (C) 2005 Yann Droneaud <ydroneaud@meuh.org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/* This file implements some of the encoding described in 
   RFC 3548: The Base16, Base32, and Base64 Data Encodings */

#if !defined(_ENCODING_RFC_3548_H_) || !_ENCODING_RFC_3548_H_

#define _ENCODING_RFC_3548_H_ 1

#include <sys/types.h>

/*
 * RFC 3548
 *  6.  Base 16 Encoding
 *
 * base16 (aka hexadecimal)
 * a well known encoding
 *
 */

size_t
base16_encode_len(size_t bin_size);

size_t
base16_encode(char *str,
	      const unsigned char *bin, size_t bin_size);

/* alias for base16_encode() */
size_t
base16_up_encode(char *str,
		 const unsigned char *bin, size_t bin_size);

size_t
base16_low_encode(char *str,
		  const unsigned char *bin, size_t bin_size);

/* 
 * RFC 3548
 *  5.  Base 32 Encoding
 *
 */

size_t
base32_encode_len(size_t bin_size);

size_t
base32_encode(char *str,
	      const unsigned char *bin, size_t bin_size);

size_t
base32_up_encode(char *str,
		 const unsigned char *bin, size_t bin_size);

size_t
base32_low_encode(char *str,
		  const unsigned char *bin, size_t bin_size);

/*
 * RFC 3548
 *  4.  Base 64 Encoding with URL and Filename Safe Alphabet
 *
 * base64ufs:
 * base64 adapted for url/filename described in RFC 3548
 *
 */

size_t
base64_encode_len(size_t bin_size);

size_t
base64_ufs_encode(char *str,
		  const unsigned char *bin, size_t bin_size);

#endif /* _ENCODING_RFC_3548_H_ */
