/*
 *  mod_bt - Making Things Better For Seeders
 *  Copyright 2004 Tyler MacDonald <tyler@yi.org>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* libc */
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
/* local */
#include <libbtutil.h>

int bt_random_seed()
{
 int fd;
 unsigned int seed;

 if((fd = open("/dev/random", O_RDONLY)) < 0)
 {
  fprintf(stderr, "open(/dev/random) failed: %s\n", strerror(errno));
  fflush(stderr);
  return 0;
 }

 read(fd, &seed, sizeof(seed));
 close(fd);
 srand(seed);

 return 1;
}
