#ifndef LIBBTUTIL_CONST_H
#define LIBBTUTIL_CONST_H

#include <stdint.h>
#include <inttypes.h>

/* peer and infohash ID's are SHA1 sums. */
#define BT_HASH_LEN             20
#define BT_INFOHASH_LEN         BT_HASH_LEN
#define BT_PEERID_LEN           BT_HASH_LEN
#define BT_EMPTY_HASH   \
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
#define BT_EMPTY_PEERID         BT_EMPTY_HASH
#define BT_EMPTY_INFOHASH       BT_EMPTY_HASH

/* string lengths */
#define BT_SHORT_STRING         512
#define BT_TINY_STRING          16
#define BT_FILE_LEN             256
#define BT_PATH_LEN             2048
#define BT_EVENT_LEN            BT_TINY_STRING
/* maximum length of a summary description of a peer.
 * summary descriptions include:
 *
 * - bencode response from an /announce request
 *   (btt_peer2compact, btt_peer2nopeerid, btt_peer2bencode)
 * - HTML table row representing a peer on an infohash page
 *   (btt_peer2tr)
 *
 * this is used for soft allocation; if this number is too low, a lot
 * of realloc()'s will happen.
 */
#define BT_PEERSTR_LEN          BT_SHORT_STRING

/* how we should represent timestamps */
#define BT_NICE_DATE            "%Y/%m/%d %H:%M:%S"

/* normalize off_t's and size_t's between 32-bit and 64-bit systems */
#define BT_OFF_T_FMT            "%"PRIu64
typedef uint64_t        bt_off_t;

#define BT_SIZE_T_FMT           "%"PRIu64
typedef uint64_t        bt_size_t;

/* This is how I would *expect* it to work... */
#if SIZEOF_TIME_T == 4
#define BT_TIME_T_FMT           "%l"PRIu32
#else
#define BT_TIME_T_FMT           "%"PRIu64
#endif

/* largest metainfo (.torrent) file we will try to process */
#define BT_MAX_METAINFO_SIZE    2097152

/* HTTP response codes a tracker may return to a peer or web browser */
#define HTTP_OK                 200
#define HTTP_CREATED            201
#define HTTP_BAD_REQUEST        400
#define HTTP_UNAUTHORIZED       401
#define HTTP_NOT_FOUND          404
#define HTTP_LOCKED             423
#define HTTP_SERVER_ERROR       500

/* for use with already allocated buffers */
#define BT_STRMAX(x)            (sizeof(x) - 1)
#define BT_STRCPY(x, y)         strncpy(x, y, BT_STRMAX(x))
#define BT_MEMCPY(x, y)         memcpy(x, y, sizeof(x))

#endif /* LIBBTUTIL_CONST_H */
