<? include("header.phpi") ?>

<h2>Documentation</h2>

<h3>php_mod_bt</h3>

<P><EM>PHP language bindings for mod_bt</EM></P>
  
  <H1>SYNOPSIS</H1>
  
  <BLOCKQUOTE><PRE>
	dl("php_mod_bt.so");		# or specify in php.ini for faster access
	
	if($hashes = tracker_infohashes())
	{
	 foreach(array_keys($hashes) as $h)
	 {
	  print "Hash \"$h\" (" . $hashes[$h]["filename"] . ") has " . $hashes[$h]["peers"] .
	  	"peers, " . $hashes[$h]["seeds"] . " of which are seeds.<BR>\n";
	 }
	}
  </PRE></BLOCKQUOTE>
  
  <H1>DESCRIPTION</H1>
  
  <P>
   The <CODE>php_mod_bt</CODE> extension provides a direct interface from the PHP language
   to information about a running <CODE>mod_bt</CODE> tracker on the same apache server.
  </P>
  
  <H1>FUNCTIONS</H1>
  
  <H2>tracker_config()</H2>

  <P>Returns an associative array describing the tracker's current configuration.</P>
  
  <H2>tracker_stats()</H2>
  
  <P>Returns an associative array giving statistics on the tracker's operation.</P>
  
  <H2>tracker_flags()</H2>
  
  <P>
   Returns an associative array of all possible tracker configuration flags;
   the keys are the binary values of the flags, and the values are the flags'
   configuration names.
  </P>
  
  <H2>tracker_infohashes()</H2>
  
  <P>
   Returns an associative array of every torrent the tracker knows about, the keys being 40-byte hexadecimal
   representations of the 20-byte infohash, the values being arrays containing key/value pairs
   which provide details about the hash.
  </P>
  
  <H2>tracker_infohash($infohash)</H2>
  
  <P>
   Given a 40-byte hexadecimal representation of a 20-byte infohash, returns an associative array containing
   details about that hash.
  </P>
  
  <H2>tracker_peers($infohash)</H2>
  
  <P>
   Given a 40-byte hexadecimal representation of a 20-byte infohash, returns an associative array of
   all peers presently connected to that torrent. The keys are 40-byte hexadecimal represenatations
   of the peers' 20-byte peer id, and the values are associative arrays containing details for the peers.
  </P>
  
  <H2>tracker_peer_flags()</H2>

  <P>
   Returns an associative array of all possible peer information flags;
   the keys are the binary values of the flags, and the values are the flags'
   configuration names.
  </P>
  
<? include("footer.phpi") ?>
