/*
 *  mod_bt - Making Things Better For Seeders
 *  Copyright 2006 Tyler MacDonald <tyler@yi.org>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


#include <libbtutil.h>
#include <libbtpeer.h>

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>

#include <apr.h>
#include <apr_pools.h>
#include <apr_errno.h>
#include <apr_strings.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>

static const char* banner = "\
btp_downloadheadless "VERSION" - download and upload files with BitTorrent\n\
\n\
";

int main(int argc, char **argv) {
    apr_pool_t*         pool = NULL;
    btp_session*        s;
    btp_session_config  c = new_btp_session_config;

    printf(banner);
    
    if(apr_app_initialize(NULL, NULL, NULL) != APR_SUCCESS) {
        fprintf(stderr, "apr_app_initialize() failed!\n");
        fflush(stderr);
        exit(4);
    }
 
    atexit(apr_terminate);
 
    if(apr_pool_initialize() != APR_SUCCESS) {
        fprintf(stderr, "apr_pool_initialize() failed!\n");
        fflush(stderr);
        exit(4);
    }
 
    if(apr_pool_create(&pool, NULL) != APR_SUCCESS) {
        fprintf(stderr, "apr_pool_create() failed!\n");
        fflush(stderr);
        exit(4);
    }

    apr_hook_global_pool = pool;
    
    c.f |= BTP_SESSION_FLAG_DEBUG;
    
    if(!(s = btp_session_create(pool, c))) {
        fprintf(stderr, "failed to create a btpeer session!\n");
        fflush(stderr);
        exit(5);
    }
    
    printf("BitTorrent session listening on port %u.\n", s->c.port);
        
    exit(0);
}
