/* VERY simple HTTP URL handling for announce, etc. requests */

#include <apr.h>
#include <apr_errno.h>
#include <apr_pools.h>
#include <apr_network_io.h>
#include <apr_strings.h>
#include <stdlib.h>
#include <libbtutil/const.h>
#include <libbtutil/util.h>

char* bt_args2url(
    apr_pool_t* p, const char* addr, apr_port_t port, const char* path
) {
    if(port == 80)
        return apr_psprintf(p, "http://%s%s", addr, path);
    else
        return apr_psprintf(p, "http://%s:%i%s", addr, port, path);
}

apr_status_t bt_url2args(
    const char* url, char* addr, apr_port_t* port, char* path
) {
    char* s;
    char* s2;
    char* s3;
    char myurl[BT_PATH_LEN];
    
    BT_STRCPY(myurl, url);
    
    /* Skip spaces */
    s3 = myurl;
    while(*s3 && *s3 == ' ')
        s3++;

    /* Parse announce URL */
    
    if(strlen(s3) > BT_SHORT_STRING - 1) {
        fprintf(stderr, "Too long announce url (%s)\n", s3);
        return APR_ENOMEM;
    }
    
    if(strncmp(s3, "http://", 7)) {
        fprintf(stderr, "Invalid announce URL (%s)\n", s3);
        return APR_EINVAL;
    }
    
    s  = strchr(s3 + 7, ':');
    s2 = strchr(s3 + 7, '/');
    
    if(s && s < s2) {
        memcpy(addr, s3 + 7, (long)s - (long)s3 - 7);
        addr[(long)s - (long)s3 - 7] = 0;
        *port = atoi(s + 1);
    } else if(s2) {
        memcpy(addr, s3 + 7, (long)s2 - (long)s3 - 7);
        addr[(long)s2 - (long)s3 - 7] = 0;
        *port = 80;
    } else {
        fprintf(stderr, "Invalid announce URL (%s)\n", s3);
        return APR_EINVAL;
    }
    
    strcpy(path, s2);
    return APR_SUCCESS;

}
