#ifndef LIBBTTRACKER_TXN_H
#define LIBBTTRACKER_TXN_H

/* other libs */
#include <apr.h>
#include <apr_pools.h>
#include <db.h>
/* local */
#include <libbttracker/types.h>
#include <libbtutil/const.h>

/* btt_txn_start.c */
extern int btt_txn_start(
    btt_tracker* tracker, DB_TXN* ptxn, DB_TXN** txn, int flags
);

/* btt_txn_iterate.c */
#define BT_CALLBACK_STOP -420
#define BT_CALLBACK_STOP_ALL -421

typedef int (*btt_txn_iter_callback) (
    apr_pool_t*, DB_TXN*, DBC*, DBT*, DBT*, void*
);

typedef struct btt_txn_iterator_s {
    btt_txn_iter_callback   callback;
    void*                   data;
} btt_txn_iterator;

extern int btt_txn_iterate_callbacks(
    apr_pool_t* p, DB_TXN* txn, DBC* cursor, DBT* key, DBT* val,
    const btt_txn_iterator callbacks[]
);

extern int btt_txn_iterate_peerlist(
    btt_tracker* tracker, apr_pool_t* p, btt_infohash* hash, DB_TXN* txn,
    int c_flags, int cc_flags, const btt_txn_iterator callbacks[]
);

/* btt_txn_register_hash.c */
extern int btt_txn_register_hash(
    btt_tracker* tracker, apr_pool_t* p, DB_TXN* txn,
    const char* infohash, const char* filename, const bt_size_t filesize
);

/* btt_txn_load_peercursor.c */
extern btt_peer* btt_txn_load_peer(
    btt_tracker* tracker, apr_pool_t* p, DB_TXN* txn, DBT* key,
    int cc_flags, int c_flags, btt_infohash* hash
);

extern int btt_txn_save_peer(
    btt_tracker* tracker, apr_pool_t* p, DB_TXN* txn, btt_peer* peer,
    btt_infohash* hash
);

extern int btt_txn_load_peercursor(
    btt_tracker* tracker, apr_pool_t* p, DB_TXN* txn, DBT* key, DBT* val,
    DBC** cursor, int cc_flags, int c_flags, btt_infohash* hash
);

/* btt_txn_load_hashcursor.c */
extern btt_infohash* btt_txn_load_hash(
    btt_tracker* tracker, apr_pool_t* p, DB_TXN* txn, DBT* key,
    int cc_flags, int c_flags, int create
);

extern int btt_txn_save_hash(
    btt_tracker* tracker, apr_pool_t* p, DB_TXN* txn, btt_infohash* hash
);

extern int btt_txn_load_hashcursor(
    btt_tracker* tracker, apr_pool_t* p, DB_TXN* txn, DBT* key, DBT* val,
    DBC** cursor, int cc_flags, int c_flags, int create
);

#endif /* LIBBTTRACKER_TXN_H */
