#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "moblin-system-dbus.h"

gboolean
set_time(MoblinSystemServer * server,
	const gint year, const gint month, const gint day,
	const gint hour, const gint minute, const gint second,
	GError **error)
{
    PRINTF("Set Time: Y:%d, M:%d, D:%d, h:%d, m:%d, s:%d\n",
	year, month, day, hour, minute, second);
    oobs_time_config_set_time(OOBS_TIME_CONFIG (server->time_config),
	year, month, day, hour, minute, second);
    oobs_object_commit(server->time_config);
    return TRUE;
}

gboolean
get_time(MoblinSystemServer * server, 
	gint *year, gint *month, gint *day, 
	gint *hour, gint *minute, gint *second,
	GError **error)
{
    oobs_time_config_get_time (OOBS_TIME_CONFIG (server->time_config),
	year, month, day, hour, minute, second);
    PRINTF("Get Time: Y:%d, M:%d, D:%d, h:%d, m:%d, s:%d\n",
	*year, *month, *day, *hour, *minute, *second);
    return TRUE;
}

gboolean
set_timezone(MoblinSystemServer * server, 
	const gchar *tz, GError **error)
{
gint year, month, day, hour, minute, second;

    PRINTF("Set Timezone: %s\n", tz);
    oobs_time_config_get_utc_time (OOBS_TIME_CONFIG (server->time_config),
	&year, &month, &day, &hour, &minute, &second);
    oobs_time_config_set_timezone (OOBS_TIME_CONFIG (server->time_config), tz);
    oobs_object_commit (server->time_config);
    oobs_time_config_set_utc_time(OOBS_TIME_CONFIG (server->time_config),
	year, month, day, hour, minute, second);
    oobs_object_commit (server->time_config);

    return TRUE;
}

gboolean
get_timezone(MoblinSystemServer * server, 
	gchar **tz, GError **error)
{
const gchar *timezone;

    timezone = oobs_time_config_get_timezone (OOBS_TIME_CONFIG (server->time_config));
    *tz = g_strdup(timezone);
    PRINTF("Get Timezone: %s\n", (*tz)?(*tz):"No Timezone Set");
    return TRUE;
}
