#include "moblin.h"
#include <gconf/gconf-client.h>

const char *
shortcut_keys[HANDLED_SHORTCUT_KEYS] = {
	GCONF_BINDING_DIR "/volume_mute",
	GCONF_BINDING_DIR "/volume_down",
	GCONF_BINDING_DIR "/volume_up",
	GCONF_BINDING_DIR "/play",
	GCONF_BINDING_DIR "/pause",
	GCONF_BINDING_DIR "/stop",
	GCONF_BINDING_DIR "/previous",
	GCONF_BINDING_DIR "/next",
	GCONF_BINDING_DIR "/home",
	GCONF_BINDING_DIR "/search",
	GCONF_BINDING_DIR "/email",
	GCONF_BINDING_DIR "/help",
	GCONF_BINDING_DIR "/www",
	GCONF_BINDING_DIR "/calc",
	GCONF_BINDING_DIR "/term",
	GCONF_BINDING_DIR "/chat",
	GCONF_BINDING_DIR "/memo",
	GCONF_BINDING_DIR "/dict",
	GCONF_BINDING_DIR "/tasks",
	GCONF_BINDING_DIR "/media",
	GCONF_BINDING_DIR "/contacts",
	GCONF_BINDING_DIR "/brightness_up",
	GCONF_BINDING_DIR "/brightness_down",
	GCONF_BINDING_DIR "/brightness_maxmin",
};

const char *
shortcut_cmd_keys[HANDLED_SHORTCUT_KEYS] = {
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	GCONF_BINDING_DIR "/home_cmd",
	GCONF_BINDING_DIR "/search_cmd",
	GCONF_BINDING_DIR "/email_cmd",
	GCONF_BINDING_DIR "/help_cmd",
	GCONF_BINDING_DIR "/www_cmd",
	GCONF_BINDING_DIR "/calc_cmd",
	GCONF_BINDING_DIR "/term_cmd",
	GCONF_BINDING_DIR "/chat_cmd",
	GCONF_BINDING_DIR "/memo_cmd",
	GCONF_BINDING_DIR "/dict_cmd",
	GCONF_BINDING_DIR "/tasks_cmd",
	GCONF_BINDING_DIR "/media_cmd",
	GCONF_BINDING_DIR "/contacts_cmd",
	NULL,
	NULL,
	NULL,
};

const char *
sound_keys[HANDLED_SOUND_KEYS] = {
	GCONF_SOUND_DIR "/volume_step",
};

const char *
networkproxy_keys[HANDLED_NETWORKPROXY_KEYS] = {
	GCONF_HTTP_PROXY_DIR "/use_http_proxy",
	GCONF_HTTP_PROXY_DIR "/use_same_proxy",
	GCONF_HTTP_PROXY_DIR "/host",
	GCONF_HTTP_PROXY_DIR "/port",
	GCONF_HTTP_PROXY_DIR "/use_authentication",
	GCONF_HTTP_PROXY_DIR "/authentication_user",
	GCONF_HTTP_PROXY_DIR "/authentication_password",
	GCONF_HTTP_PROXY_DIR "/ignore_hosts",
	GCONF_PROXY_DIR "/mode",
	GCONF_PROXY_DIR "/secure_host",
	GCONF_PROXY_DIR "/old_secure_host",
	GCONF_PROXY_DIR "/secure_port",
	GCONF_PROXY_DIR "/old_secure_port",
	GCONF_PROXY_DIR "/ftp_host",
	GCONF_PROXY_DIR "/old_ftp_host",
	GCONF_PROXY_DIR "/ftp_port",
	GCONF_PROXY_DIR "/old_ftp_port",
	GCONF_PROXY_DIR "/socks_host",
	GCONF_PROXY_DIR "/old_socks_host",
	GCONF_PROXY_DIR "/socks_port",
	GCONF_PROXY_DIR "/old_socks_port",
	GCONF_PROXY_DIR "/autoconfig_url",
};

const char *
font_keys[HANDLED_FONT_KEYS] = {
	GCONF_FONT_DIR "/font_name",
	GCONF_FONT_DIR "/desktop_font",
	GCONF_FONT_DIR "/monospace_font_name",
	GCONF_FONT_DIR "/document_font_name",
};

const char *
gnome_font_keys[HANDLED_FONT_KEYS] = {
	GNOME_GCONF_FONT_DIR "/font_name",
	NAUTILUS_GCONF_FONT_DIR "/desktop_font",
	GNOME_GCONF_FONT_DIR "/monospace_font_name",
	GNOME_GCONF_FONT_DIR "/document_font_name",
};

const char *
background_keys[HANDLED_BACKGROUND_KEYS] = {
	GCONF_BACKGROUND_DIR "/picture_filename",
	GCONF_BACKGROUND_DIR "/picture_options",
	GCONF_BACKGROUND_DIR "/color_shading_type",
	GCONF_BACKGROUND_DIR "/primary_color",
	GCONF_BACKGROUND_DIR "/secondary_color",
	GCONF_BACKGROUND_DIR "/thumbpaths",
};

const char *
gnome_background_keys[HANDLED_BACKGROUND_KEYS] = {
	GNOME_GCONF_BACKGROUND_DIR "/picture_filename",
	GNOME_GCONF_BACKGROUND_DIR "/picture_options",
	GNOME_GCONF_BACKGROUND_DIR "/color_shading_type",
	GNOME_GCONF_BACKGROUND_DIR "/primary_color",
	GNOME_GCONF_BACKGROUND_DIR "/secondary_color",
	GNOME_GCONF_BACKGROUND_DIR "/thumbpaths",
};

const char *
theme_keys[HANDLED_THEME_KEYS] = {
	GCONF_THEME_DIR "/gtk_theme",
	GCONF_THEME_DIR "/icon_theme",
	GCONF_THEME_DIR "/gtk_color_scheme",
	GCONF_THEME_DIR "/disable_theme_settings",
};

const char *
gnome_theme_keys[HANDLED_THEME_KEYS] = {
	GNOME_GCONF_THEME_DIR "/gtk_theme",
	GNOME_GCONF_THEME_DIR "/icon_theme",
	GNOME_GCONF_THEME_DIR "/gtk_color_scheme",
	GNOME_GCONF_LOCKDOWN_DIR "/disable_theme_settings",
};

GtkIconTheme *
moblin_icon_theme_get_default(void)
{
    GtkIconTheme *icon_theme;
    gchar *theme_name;
    GConfClient *client;

    client = gconf_client_get_default ();
    theme_name = gconf_client_get_string(client, THEMEKEY(ICON_THEME), NULL);
    icon_theme = gtk_icon_theme_new ();
    gtk_icon_theme_set_custom_theme (icon_theme, theme_name);
    return icon_theme;
}
