/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* main.c: this file is part of time-admin, a ximian-setup-tool frontend 
 * for system time configuration.
 * 
 * Copyright (C) 2000-2001 Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Hans Petter Jansson <hpj@ximian.com>
 *          Jacob Berkman <jacob@ximian.com>
 *          Chema Celorio <chema@ximian.com>
 *          Carlos Garnacho Parro <garparr@teleline.es>
 */
 
#include <config.h>

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>

#include <glib/gi18n.h>
#include "gst.h"
#include "time-tool.h"

#include "tz.h"
#include "e-map/e-map.h"
#include "tz-map.h"

ETzMap *tzmap;

static void timezone_button_clicked (GtkWidget *w, gpointer data);

static GstDialogSignal signals[] = {
	{ "timezone_button",     "clicked",  G_CALLBACK (timezone_button_clicked) },
	{ NULL, NULL }
};

static void
timezone_button_clicked (GtkWidget *w, gpointer data)
{
	GstTimeTool *time_tool;
	GstDialog *dialog;

	dialog = GST_DIALOG (data);
	time_tool = GST_TIME_TOOL (gst_dialog_get_tool (dialog));
	gst_time_tool_run_timezone_dialog (time_tool);
}

int main(int argc, char *argv[])
{
	static GstTool *tool = NULL;

	gtk_init(&argc, &argv);

	/* The GstTool object is now a static since the applet */
	/* may be started multiple times within a single controlpanel */
	/* process run. tool stays valid until controlpanel dies */

	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	if(!tool) tool = GST_TOOL (gst_time_tool_new ());

	gst_dialog_connect_signals (tool->main_dialog, signals);
	gtk_widget_show (GTK_WIDGET (tool->main_dialog));
	gtk_main ();

	return OSSO_OK;
}
