/*
 * ConnectionMgr manages a single connection from the user interface, 
 * and forward the commands to the appropriate agent.
 * 
 * Copyright © 2007, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307 USA.
 *
 */
#ifndef __CONNECTIONMGR_H__
#define __CONNECTIONMGR_H__

#include <iostream>
#include "Message.h"
#include "ProcessMgr.h"
const int MAX_BUF_SIZE = 512;

class ConnectionMgr 
{
   int m_sockfd;
   char m_buf[MAX_BUF_SIZE];

   bool m_isAlertConnection;

   bool receiveBuffer (char *buf, size_t *bufSize, int msecTimeout);
   bool canReadData(int msecTimeout);
   bool canWriteData(int msecTimeout);

   void handleMsg (Message &msg);

   public:
   ConnectionMgr (int fd);
   ~ConnectionMgr();

   void manageConnection();
   bool receiveMessage (Message *msg, int timeout);
   bool sendMessage (Message &msg);
   int getSockfd() {return m_sockfd;}
};

#endif //__CONNECTIONMGR_H__
