///////////////////////////////////////////////////////////////////////////////
// $Id: mapeditor.h,v 1.13 2004/11/30 15:37:18 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    mapeditor.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the editor window for maps
*/

#ifndef MAPEDITOR_H
#define MAPEDITOR_H

// local includes
#include "editor.h"
#include "mapeditorbase.h"

// forward declarations
class MainWindow;
class MapDocument;
class MapView;
class QAction;
class QListViewItem;
class QPopupMenu;
class QToolBar;

class MapEditor : public MapEditorBase, public Editor
{
	Q_OBJECT
public:
	MapEditor(MainWindow* mainwindow, QWidget* parent=0, const char* name=0);
	~MapEditor();

	bool newDocument();
	bool openDocument(const QString& filename);
	bool saveDocument();
	bool saveDocumentAs(const QString& filename);

	void resize();

	void cut();
	void copy();
	void paste();

	void selectAll();

	QString fileName() const;
	QString fileFilter() const;
	bool isModified() const;

	void showGrid(bool show);
	bool showsGrid() const;

private:
	void updateLayerSelector();

	void createTools();
	void createContextMenu();

private slots:
	void slotTileGroupChanged(int index);
	void slotTileSelected(QListViewItem* item);

	void slotLayerSelected(QListViewItem* item);
	void slotLayerClicked(QListViewItem* item, const QPoint&, int col);
	void slotLayerHeaderClicked(int col);
	void slotAddLayer();
	void slotRemoveLayer();
	void slotMoveLayerUp();
	void slotMoveLayerDown();
	void slotLayerBackgroundToggled(bool on);
	void slotLayerPropertiesChanged();
		
	void slotViewShowing();
	void slotViewHiding();

	void slotToolAction(QAction* action);

	void slotContextMenu(const QPoint& pos);

	void slotCut() { cut(); }
	void slotCopy() { copy(); }
	void slotPaste() { paste(); }

private:
	MainWindow* m_mainWindow;
	MapView* m_view;
	MapDocument* m_doc;

	QPopupMenu* m_toolMenu;
	int         m_toolMenuID;
	QToolBar*   m_toolBar;
	QAction*    m_actPointTool;
	QAction*    m_actLineTool;
	QAction*    m_actRectangleTool;
	QAction*    m_actSelectTool;

	QPopupMenu* m_contextMenu;
};

#endif

// End of file
