#ifndef XMLTOOLS_H
#define XMLTOOLS_H

#include "XMLElements.h"

//----------------------------------------------------------------------------
namespace XML_TOOLS
{
    //------------------------------------------------------------------------
    /**
     * Takes the propertie's string value and calls
     * STRING_TOOLS::popUnsignedFromPropertyTokenString().
     *
     * @param p The property containing the token string.
     * @param value The unsigned value to pop.
     *
     * @return true, if value was popped from the token string, else false.
     */
    bool popUnsignedFromPropertyTokenString(XMLProperty *p,
                                            const unsigned value);

    //------------------------------------------------------------------------
    /**
     * Same as popUnsignedFromPropertyTokenString(),
     * but only the first token of the propertie's value is checked.
     *
     * @param p The property containing the token string.
     * @param value The unsigned value to pop.
     *
     * @return true, if value is the first token and was popped from
     *         the token string, else false.
     */
    bool popFirstUnsignedFromPropertyTokenString(XMLProperty *p,
                                                 const unsigned value);
} //XML_TOOLS

#endif //XMLTOOLS_H
