#include "Tools.h"

#include "ObjectRepository.h"
#include "AllObjects.h"
#include "ObjectVisitors.h"


//----------------------------------------------------------------------------
ObjectVisitor::~ObjectVisitor()
{
}

//----------------------------------------------------------------------------
ObjectConstVisitor::~ObjectConstVisitor()
{
}



//----------------------------------------------------------------------------
void FindLandingPlatformConstVisitor::do_visit(const Platform *p)
{
    if (m_ship->isInLandingZone(p->getLandingZone()))
    {
        m_platform = p;
    }
}


//----------------------------------------------------------------------------
void HasCrateForShipConstVisitor::do_visit(const Crate *c)
{
    if (ObjectBase::isCollision(m_ship, c) &&
        m_ship->hasCapacity(c))
    {
        m_crate = c;
    }
}



//----------------------------------------------------------------------------
void CreateExplosionParticleConstVisitor::do_visit(const GrenadeBase *g)
{
    do_createExplosionParticles(g, 15);
    g->onCreateExplosionParticles();
}

//----------------------------------------------------------------------------
void CreateExplosionParticleConstVisitor::do_visit(const Missile *m)
{
    do_do_visit(m);
    m->onCreateExplosionParticles();
}

//----------------------------------------------------------------------------
void CreateExplosionParticleConstVisitor::do_visit(const MortarBase *m)
{
    do_createExplosionParticles(
        m, m->getPosition().w * m->getPosition().h / 4);
}

//----------------------------------------------------------------------------
void CreateExplosionParticleConstVisitor::do_visit(const ProjectileBase *p)
{
    do_createExplosionParticles(p, 5);
}

//----------------------------------------------------------------------------
void CreateExplosionParticleConstVisitor::do_visit(const SAMBatteryBase *s)
{
    do_createExplosionParticles(
        s, s->getPosition().w * s->getPosition().h / 4);
}

//----------------------------------------------------------------------------
void CreateExplosionParticleConstVisitor::do_visit(const Ship *s)
{
    do_do_visit(s);
}

//----------------------------------------------------------------------------
void CreateExplosionParticleConstVisitor::do_visit(const Tank *t)
{
    do_createExplosionParticles(
        t, t->getPosition().w * t->getPosition().h / 4);
}

//----------------------------------------------------------------------------
void CreateExplosionParticleConstVisitor::do_visit(const TurretBase *t)
{
    do_createExplosionParticles(
        t, t->getPosition().w * t->getPosition().h / 4);
}

//----------------------------------------------------------------------------
void CreateExplosionParticleConstVisitor::do_do_visit(const ControllableObjectBase *o)
{
    do_createExplosionParticles(
        o, o->getPosition().w * o->getPosition().h / 4);
}

//----------------------------------------------------------------------------
void CreateExplosionParticleConstVisitor::do_createExplosionParticles(
    const ObjectBase *o, unsigned numParticles)
{
    for (unsigned i=0; i<numParticles; i++)
    {
        ObjectRepository::getInstance()->addObject(
            new ExplosionParticle(o));
    }
}



//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const GrenadeBase *g)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();
    m_particle->setGradient();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(g->getPosition(), xm, ym);

    m_particle->setPosition(xm + 2 - myRand(5), ym + 2 - myRand(5));


    // Initialize the velocity.
    MATH_TOOLS::Vector relativeVelocity(
        1.0 * PARTICLE_VELOCITY/2 - myRand(PARTICLE_VELOCITY),
        1.0 * PARTICLE_VELOCITY/2 - myRand(PARTICLE_VELOCITY));

    m_particle->getFineVelocity() = g->getFineVelocity() + relativeVelocity;
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const Missile *m)
{
    do_do_visit(m);
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const MortarBase *m)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();
    m_particle->setGradient();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(m->getPosition(), xm, ym);

    m_particle->setPosition(xm + 6 - myRand(13), ym + 6 - myRand(13));


    // Initialize the velocity.

    double rand1 = 1.0 * myRand(PARTICLE_VELOCITY);
    double rand2 = 1.0 * myRand(PARTICLE_VELOCITY);
    double offset = -1.0 * (PARTICLE_VELOCITY/2);

    switch (m->getOrientation())
    {
    case OrientatingDecorationBase::O_TOP:
        m_particle->getFineVelocity().set(offset + rand1, rand2);
        break;
    case OrientatingDecorationBase::O_BOTTOM:
        m_particle->getFineVelocity().set(offset + rand1, -rand2);
        break;
    case OrientatingDecorationBase::O_LEFT:
        m_particle->getFineVelocity().set(rand1, offset + rand2);
        break;
    case OrientatingDecorationBase::O_RIGHT:
        m_particle->getFineVelocity().set(-rand1, offset + rand2);
        break;
    }
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const ProjectileBase *p)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(p->getPosition(), xm, ym);

    m_particle->setPosition(xm + 2 - myRand(5), ym + 2 - myRand(5));


    // Initialize the velocity.

    m_particle->getFineVelocity().set(
        1.0 * PARTICLE_VELOCITY/2 - myRand(PARTICLE_VELOCITY),
        1.0 * PARTICLE_VELOCITY/2 - myRand(PARTICLE_VELOCITY));
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const SAMBatteryBase *s)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();
    m_particle->setGradient();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(s->getPosition(), xm, ym);

    m_particle->setPosition(xm + 6 - myRand(13), ym + 6 - myRand(13));


    // Initialize the velocity.

    double rand1 = 1.0 * myRand(PARTICLE_VELOCITY);
    double rand2 = 1.0 * myRand(PARTICLE_VELOCITY);
    double offset = -1.0 * (PARTICLE_VELOCITY/2);

    switch (s->getOrientation())
    {
    case OrientatingDecorationBase::O_TOP:
        m_particle->getFineVelocity().set(offset + rand1, rand2);
        break;
    case OrientatingDecorationBase::O_BOTTOM:
        m_particle->getFineVelocity().set(offset + rand1, -rand2);
        break;
    case OrientatingDecorationBase::O_LEFT:
        m_particle->getFineVelocity().set(rand1, offset + rand2);
        break;
    case OrientatingDecorationBase::O_RIGHT:
        m_particle->getFineVelocity().set(-rand1, offset + rand2);
        break;
    }
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const Ship *s)
{
    do_do_visit(s);
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const Tank *t)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();
    m_particle->setGradient();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(t->getPosition(), xm, ym);

    m_particle->setPosition(xm + 12 - myRand(25), ym + 6 - myRand(13));


    // Initialize the velocity.

    m_particle->getFineVelocity().set(
        1.0 * PARTICLE_VELOCITY/2 - myRand(PARTICLE_VELOCITY),
        -1.0 * myRand(PARTICLE_VELOCITY));
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const TurretBase *t)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();
    m_particle->setGradient();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(t->getPosition(), xm, ym);

    m_particle->setPosition(xm + 6 - myRand(13), ym + 6 - myRand(13));


    // Initialize the velocity.

    double rand1 = 1.0 * myRand(PARTICLE_VELOCITY);
    double rand2 = 1.0 * myRand(PARTICLE_VELOCITY);
    double offset = -1.0 * (PARTICLE_VELOCITY/2);

    switch (t->getOrientation())
    {
    case OrientatingDecorationBase::O_TOP:
        m_particle->getFineVelocity().set(offset + rand1, rand2);
        break;
    case OrientatingDecorationBase::O_BOTTOM:
        m_particle->getFineVelocity().set(offset + rand1, -rand2);
        break;
    case OrientatingDecorationBase::O_LEFT:
        m_particle->getFineVelocity().set(rand1, offset + rand2);
        break;
    case OrientatingDecorationBase::O_RIGHT:
        m_particle->getFineVelocity().set(-rand1, offset + rand2);
        break;
    }
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_do_visit(const ControllableObjectBase *o)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();
    m_particle->setGradient();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(o->getPosition(), xm, ym);

    m_particle->setPosition(xm + 8 - myRand(17), ym + 8 - myRand(17));


    // Initialize the velocity.

    MATH_TOOLS::Vector relativeVelocity;
    relativeVelocity.set(
        1.0 * PARTICLE_VELOCITY/2 - myRand(PARTICLE_VELOCITY),
        1.0 * PARTICLE_VELOCITY/2 - myRand(PARTICLE_VELOCITY));

    m_particle->getFineVelocity() = o->getFineVelocity() - relativeVelocity;
}
